@echo off

rem   This is Gradint's setup file for Windows.
rem   If you are seeing this, when you expected
rem   the Gradint installer to be running, then
rem   it probably means your copy of Windows has
rem   an incorrect file association.  That will
rem   affect other programs, not just Gradint.
rem   To fix the incorrect association, try
rem   running regedit and deleting the key:
rem   Hkey_Current_User\Software\Microsoft\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.bat
rem   then restart your system and the Gradint
rem   installer should work normally.
rem   This problem has been reported on some
rem   (but not all) Windows 7 setups.

rem --------------------------------------------

rem Find a good place to put Gradint.  On Windows 9x this can be C:\Program Files.  On XP/NT/etc we'd better check for different home directories.  Also check where the profile is.

if not exist "%HOMEDRIVE%%HOMEPATH%" set HOMEDRIVE=C:
if not exist "%HOMEDRIVE%%HOMEPATH%" set HOMEPATH="\Program Files"
if not exist "%USERPROFILE%" set USERPROFILE="C:\WINDOWS"
if exist "%HOMEDRIVE%%HOMEPATH%\gradint" goto doneAlready
move gradint "%HOMEDRIVE%%HOMEPATH%\gradint"
if errorlevel 1 goto copy
goto tryZh
:copy
xcopy /I gradint "%HOMEDRIVE%%HOMEPATH%\gradint" /S
:tryZh
if not exist "%USERPROFILE%\ʼ˵" goto nextBit
rem Detected Chinese(Simplified) Windows with PRC legacy locale
rem (see comments below "goto PRC" for more explanation)
rem - let's assume their first language is "zh" for the GUI
echo firstLanguage="zh" > "%HOMEDRIVE%%HOMEPATH%\gradint\settings.txt"
echo secondLanguage="en" >> "%HOMEDRIVE%%HOMEPATH%\gradint\settings.txt"
goto nextBit

:doneAlready
if exist "%HOMEDRIVE%%HOMEPATH%\gradint\vocab.txt" goto needWarning
if exist "%HOMEDRIVE%%HOMEPATH%\gradint\settings.txt" goto needWarning
if exist "%HOMEDRIVE%%HOMEPATH%\gradint\advanced.txt" goto needWarning
if exist "%HOMEDRIVE%%HOMEPATH%\gradint\samples" goto needWarning
rem is almost certainly a failed uninstall
goto silentRepair
:needWarning
echo It seems that gradint was already installed on your system.
echo The installer will replace the program files but not the data.
echo Your vocab.txt and recorded words will not be changed,
echo and any new options will not be added to your advanced.txt
echo (see the advanced.txt on the website if you want to set them).
echo.
echo If you wanted a fresh install, stop now and uninstall first.
echo.
pause
:silentRepair
rem copy all program files, even the ones that have never been changed, in case it was a manual or python-only install
tskill gradint-wrapper 2>nul
taskkill /f /im gradint-wrapper.exe 2>nul >nul
cd gradint
rem clean up after old versions
if exist background1.txt del background1.txt
if exist background2.txt del background2.txt
rem support bundles
for /D %%g in (*_disabled) do xcopy /I %%g "%HOMEDRIVE%%HOMEPATH%\gradint\%%g" /S
rem support users who install yali BEFORE gradint
rem (don't worry about trying move and catching problems with Vista etc - just use copy)
if not exist "%HOMEDRIVE%%HOMEPATH%\gradint\settings.txt" copy settings.txt "%HOMEDRIVE%%HOMEPATH%\gradint"
if not exist "%HOMEDRIVE%%HOMEPATH%\gradint\advanced.txt" copy advanced.txt "%HOMEDRIVE%%HOMEPATH%\gradint"
if not exist "%HOMEDRIVE%%HOMEPATH%\gradint\vocab.txt" copy vocab.txt "%HOMEDRIVE%%HOMEPATH%\gradint"
if exist "%HOMEDRIVE%%HOMEPATH%\gradint\samples" goto gotSamples
xcopy /I samples "%HOMEDRIVE%%HOMEPATH%\gradint\samples" /S
goto afterGotSamples
:gotSamples
rem Update the previously-buggy whatSay_zh.txt prompt
if exist "%HOMEDRIVE%%HOMEPATH%\gradint\samples\prompts\whatSay_zh.txt" copy /Y samples\prompts\whatSay_zh.txt "%HOMEDRIVE%%HOMEPATH%\gradint\samples\prompts"
:afterGotSamples
rem also support partials in bundle
if not exist partials goto skipPartials
if exist "%HOMEDRIVE%%HOMEPATH%\gradint\partials" goto skipPartials
xcopy /I partials "%HOMEDRIVE%%HOMEPATH%\gradint\partials" /S
:skipPartials
xcopy /I /D /Y /S tcl "%HOMEDRIVE%%HOMEPATH%\gradint\tcl"
copy /Y library.zip "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y datetime.pyd "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y gradint-wrapper.exe "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y ptts.exe "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y madplay.exe "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y python23.dll "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y _sre.pyd "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y _tkinter.pyd "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y tcl84.dll "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y tk84.dll "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y unicodedata.pyd "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y zlib.pyd "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y w9xpopen.exe "%HOMEDRIVE%%HOMEPATH%\gradint"
copy /Y winsound.pyd "%HOMEDRIVE%%HOMEPATH%\gradint"
xcopy /I /D /Y /S espeak "%HOMEDRIVE%%HOMEPATH%\gradint\espeak"
copy /Y sox.exe "%HOMEDRIVE%%HOMEPATH%\gradint"
cd ..

:nextBit

rem Some old versions of gradint tried to use schtasks
rem instead of once_per_day|2.  This didn't really work.
rem If we're upgrading from one of those, we want to remove the task.
schtasks /delete /tn gradint /f 2>nul

rem Make desktop and start menu shortcuts
if not exist startup cd gradint
rem (if running from the live CD)

if exist "%USERPROFILE%\ʼ˵" goto PRC
if exist "%USERPROFILE%\Desktop" goto noWarning
cls
echo === BIG FAT WARNING !!! ===
echo.
echo It seems you are running a non-English version of Windows.
echo This simple batch file knows that your profile is located at
echo %USERPROFILE%
echo but it can only assume that your desktop is
echo %USERPROFILE%\Desktop
echo and your start menu is
echo %USERPROFILE%\Start Menu
echo.
echo NON-ENGLISH VERSIONS OF WINDOWS USE DIFFERENT NAMES FOR THESE FOLDERS.
echo This simple batch file has no way of knowing where your desktop and start
echo menu really are.  It will therefore create folders called 'Desktop' and
echo 'Start Menu' in your profile folder %USERPROFILE%.
echo YOU WILL NEED TO MANUALLY GO INTO THAT FOLDER AND MOVE THE CONTENTS OF
echo Desktop AND Start Menu TO YOUR REAL DESKTOP AND START MENU, otherwise
echo your gradint will NOT be easily accessible.
echo If you do not know what this means, FIND SOMEONE TO HELP YOU.
echo Press any key to continue.
pause >nul
rem (deliberately saying "press any key" ourselves not from 'pause', otherwise that part will be in their own language and they might not try to read the English message before it)
:noWarning

mkdir "%USERPROFILE%\Desktop\gradint"
copy /Y shortcuts\*.* "%USERPROFILE%\Desktop\gradint"
if exist "%AppData%\Microsoft\Windows\Start Menu\Programs\Startup" goto win8
mkdir "%USERPROFILE%\Start Menu\Programs\gradint"
copy /Y shortcuts\*.* "%USERPROFILE%\Start Menu\Programs\gradint"

rem Install startup once-per-day thing
mkdir "%USERPROFILE%\Start Menu\Programs\Startup"
copy /Y startup\*.* "%USERPROFILE%\Start Menu\Programs\Startup"

goto win8skip
:win8
copy /Y startup\*.* "%AppData%\Microsoft\Windows\Start Menu\Programs\Startup"
mkdir "%AppData%\Microsoft\Windows\Start Menu\Programs\gradint"
copy /Y shortcuts\*.* "%AppData%\Microsoft\Windows\Start Menu\Programs\gradint"
:win8skip

cd /D "%USERPROFILE%\Desktop"
goto end

:PRC
rem This is a special case for Chinese (Simplified) Windows (XP etc), configured to use the "Chinese (PRC)" locale for legacy apps (which means these strings should be gb2312 coded).
rem (You can get the names of Start Menu etc folders coded in the current locale by doing dir > file.txt at a command prompt and inspecting file.txt)
mkdir "%USERPROFILE%\\gradint"
ren shortcuts\uninstall.bat "shortcuts\ų.bat"
copy /Y shortcuts\*.* "%USERPROFILE%\\gradint"
mkdir "%USERPROFILE%\ʼ˵\\gradint"
copy /Y shortcuts\*.* "%USERPROFILE%\ʼ˵\\gradint"
mkdir "%USERPROFILE%\ʼ˵\\"
copy /Y startup\*.* "%USERPROFILE%\ʼ˵\\"
cd /D "%USERPROFILE%\"

:end
rem Open the Gradint desktop folder
rem start explorer gradint

rem (actually, since there's only 1 shortcut now,
rem we might as well just launch it directly)
cd /D "%HOMEDRIVE%%HOMEPATH%\gradint"
start gradint-wrapper.exe once_per_day=disable_once_per_day=2
