# make-flashcards.py - Python script to make flashcards for flashcards.html
# (C) 2008 Silas S. Brown.  License: GPL

# Requires a Unix environment with CJK-LaTeX and Arphic
# fonts (e.g. from Debian) and netpbm.
# Put make-flashcards.py in a temporary directory, with
# characters.txt and LatexPaper.py from my website.
# It will make *.png - put this into the F/ directory.

# card 1 is put on 1.png, answer on 2.png
# card 2 is put on 3.png, answer on 4.png
# etc.

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

dpi_to_set_at = 100 # regardless of actual device DPI - be nice to metafont
papersize_px = (240,320)
baseSize_points = 12 ; import os
fontsize_px = papersize_px[1] / 2 # allow up to 2 lines on the screen
fontsize_pt = fontsize_px * 72.0 / dpi_to_set_at
papersize_mm = tuple(map(lambda x: x*25.4/dpi_to_set_at, papersize_px))
latex_paper_command = "margin_left=0 margin_top=0 paper_width="+str(papersize_mm[0])+" paper_height="+str(papersize_mm[1])+" python LatexPaper.py "+str(baseSize_points)+" "+str(fontsize_pt)+" "
def f(x):
    py=x[x.index("[")+1:x.index("]")].replace("u:","v").replace("Long","LONG").replace("long","Long")
    if len(py)>5: size="tiny"
    elif len(py)>4: size="scriptsize"
    else: size="small"
    return "\\begin{CJK*}{GB}{song}"+x[:x.index(" ")]+"\\end{CJK*}\\newpage{\\"+size+" \\"+py+"}"
open("tmp.tex","w").write("\\documentclass[12pt]{article}"+os.popen(latex_paper_command+"tex").read()+"\\usepackage[T1]{fontenc}\\usepackage{CJK}\\usepackage{pinyin}\\begin{document}"+"\\newpage\n".join(map(f,filter(lambda x:"]" in x,open("characters.txt").readlines())))+"\\end{document}")
ret = os.system("latex tmp.tex")
assert not ret, "TeX error"
ret = os.system(os.popen(latex_paper_command+"tmp.dvi").read().strip()+" -o tmp.ps -D "+str(dpi_to_set_at))
assert not ret, "dvips error"
ret = os.system("gs -sDEVICE=png16 -sOutputFile=%%d.png -g%dx%d -r%dx%d -q -dNOPAUSE - < tmp.ps" % (papersize_px[0],papersize_px[1],dpi_to_set_at,dpi_to_set_at))
assert not ret, "gs error"
pngs = os.listdir(os.getcwd()) ; pngs.sort()
os.system("for N in *.png; do pngtopnm $N | pnmcrop -white | pnmtopng -compression 9 > $N.new ; mv $N.new $N; done")
os.system("tar -jcvf pngs.tbz *.png && rm *.png tmp.* && echo '.png files have been put into pngs.tbz'")
