#!/usr/bin/env python
# -*- coding: utf-8 -*-

# NOTE: this version has been automatically TRIMMED for S60 (some non-S60 code taken out)

program_name = "gradint v3.11 (c) 2002-25 Silas S. Brown. GPL v3+."
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
progressFileHeader = "# -*- mode: python -*-\n# Do not add more comments - this file will be overwritten\n"
appTitle = "Language lesson"
import sys,os
if sys.version_info[0]>2:
    _map,_filter = map,filter
    def map(*args): return list(_map(*args))
    def filter(*args): return list(_filter(*args))
    from functools import cmp_to_key
    def sort(l,c): l.sort(key=cmp_to_key(c))
    raw_input,unichr,xrange,long = input,chr,range,int
    def chr(x): return unichr(x).encode('latin1')
    from subprocess import getoutput
    popenRB,popenWB = "r","w"
    def unicode(b,enc):
        if type(b)==str: return b
        return b.decode(enc)
else:
    def sort(l,c): l.sort(c)
    popenRB,popenWB = "rb","wb"
    bytes = str
    try: from commands import getoutput
    except ImportError: pass
    try: True
    except: exec("True = 1 ; False = 0")
def readB(f,m=None):
    if hasattr(f,"buffer"): f0,f=f,f.buffer # Python 3 non-"b" file
    if m: return f.read(m)
    else: return f.read()
def writeB(f,b):
    if hasattr(f,"buffer"): f0,f=f,f.buffer # Python 3 non-"b" file
    f.write(b)
def B(x):
    if type(x)==bytes: return x
    try: return x.encode('utf-8')
    except: return x
def LB(x):
    if type(x)==bytes: return x
    try: return x.encode('latin1')
    except: return x
def S(x):
    if type(x)==bytes and not bytes==str: return x.decode('utf-8')
    return x
def S2(s):
    try: return S(s)
    except: return s
firstLanguage = "en"
secondLanguage = "zh"
otherLanguages = ["cant","ko","jp"]
possible_otherLanguages = ["cant","ko","jp","en","zh",
                           "zhy","zh-yue"]
otherFirstLanguages = []
prefer_espeak = "en"
sapiVoices = {
}
sapiSpeeds = {
}
macVoices = {
"en":"Emily Daniel Alex Vicki",
"zh":"Ting-Ting Tingting",
"cant":"Sin-Ji",
"jp":"Kyoko",
"ind":"Damayanti",
}
ekho_speed_delta = 0
systemVoice = "en"
extra_speech = []
extra_speech_tofile = []
synthCache = ""
synthCache_test_mode = 0
justSynthesize = ""
lily_file = "C:\\Program Files\\NeoSpeech\\Lily16\\data-common\\userdict\\userdict_chi.csv"
ptts_program = None
partialsDirectory = "partials"
betweenPhrasePause = 0.3
partials_are_sporadic = 0
voiceOption = ""
espeak_preprocessors={
}
max_extra_buttons = 12
mp3web = ""
mp3webName = ""
downloadsDirs = ["../Downloads","..\\Desktop"]
outputFile = ""
compress_SH = False
outputFile_appendSilence = 0
if outputFile.endswith("cdr"): outputFile_appendSilence = 5
beepThreshold = 20
startAnnouncement = None
endAnnouncement = None
commentsToAdd = None
orderlessCommentsToAdd = None
maxLenOfLesson = 30*60
saveProgress = 1
ask_teacherMode = 0
maxNewWords = 5
maxReviseBeforeNewWords = 3
newInitialNumToTry = 5
recentInitialNumToTry = 3
newWordsTryAtLeast = 3
knownThreshold = 5
reallyKnownThreshold = 10
meaningTestThreshold = 20
randomDropThreshold = 14
randomDropLevel = 0.67
randomDropThreshold2 = 35
randomDropLevel2 = 0.97
seedless = 0
shuffleConstant = 2.0
transitionPromptThreshold = 10
advancedPromptThreshold = 20
transitionPromptThreshold2 = 2
advancedPromptThreshold2 = 5
veryExperiencedThreshold = 1000
limit_words = max(1,int(maxNewWords * 0.4))
logFile = "log.txt"
briefInterruptLength = 10
vocabFile = "vocab.txt"
samplesDirectory = "samples"
promptsDirectory = "samples"+os.sep+"prompts"
progressFile = "progress.txt"
progressFileBackup = "progress.bak"
pickledProgressFile = "progress.bin"
gui_output_directory = "output"
limit_filename = "!limit"
intro_filename = "_intro"
poetry_filename = "!poetry"
variants_filename = "!variants"
exclude_from_scan = "_disabled"
exclude_from_coverage = "z_try_again"
userNameFile="username.txt"
import_recordings_from = [r"\My Documents", r"\Storage Card\My Documents", r"\Ramdisk\My Documents"]
GUI_translations={
"@variants-zh":[u"简体字",u"繁體字"],
"Word in %s":{"zh":u"%s"},
"Meaning in %s":{"zh":u"%s意思"},
"en":{"zh":u"英文"},
"zh":{"zh":u"汉语","zh2":u"漢語"},
"cant":{"zh":u"粵語","zh2":u"廣東話"},
"Your first language":{"zh":u"母语","zh2":u"母語"},
"second":{"zh":u"学习的语言","zh2":u"學習的語言"},
"Change languages":{"zh":u"选择其他语言","zh2":u"選擇其他語言"},
"Cancel lesson":{"zh":u"退出"},
"Cancel selection":{"zh":u"取消"},
"Clear input boxes":{"zh":u"取消"},
"Manage word list":{"zh":u"管理词汇表","zh2":u"管理詞彙表"},
"Create word list":{"zh":u"创造词汇表","zh2":u"創造詞彙表"},
"words in":{"zh":u"词, 用","zh2":u"詞, 用"},
"new words in":{"zh":u"新词, 用","zh2":u"新詞, 用"},
"mins":{"zh":u"分钟","zh2":u"分鐘"},
"Start lesson":{"zh":u"开始","zh2":u"開始"},
"Quit":{"zh":u"关闭","zh2":"關閉"},
"Back to main menu":{"zh":u"回主选单","zh2":u"回主選單"},
"Delete non-hanzi":{"zh":u"除字非汉字","zh2":u"除字非漢字"},
"Speak":{"zh":u"发音","zh2":u"發音"},
"Add to %s":{"zh":u"添加到%s"},
"vocab.txt":{"zh":u"词汇表","zh2":u"詞彙表"},
"Recorded words":{"zh":u"录音词汇","zh2":u"錄音詞彙"},
"To":{"zh":u"转到","zh2":"轉到"},
"Make":{"zh":u"做"},
"Speaker":{"zh":u"扬声器","zh2":u"揚聲器"},
"Change or delete item":{"zh":u"更换/删除","zh2":u"更換/刪除"},
"You have not changed the test boxes.  Do you want to delete %s?":{"zh":u"你还没编辑了。你想删除%s吗?","zh2":u"你還沒編輯了。你想刪除%s嗎?"},
"Restore":{"zh":u"归还","zh2":u"歸還"},
"Hear this lesson again?":{"zh":u"再次听那个课吗?","zh2":u"再次聽那個課嗎?"},
"Start this lesson again?":{"zh":u"再次开始这个课吗?","zh2":u"再次開始這個課嗎?"},
"You have %d words in your collection":{"zh":u"你的汇编有%d词","zh2":u"你的彙編有%d詞"},
"%d new words + %d old words":{"zh":u"%d新词而%d旧词","zh2":u"%d新詞而%d舊詞"},
"minutes":{"zh":u"分钟","zh2":u"分鐘"},
"seconds":{"zh":u"秒"},
"Today's lesson teaches %d new words\nand revises %d old words\n\nPlaying time: %d %s %d %s":{"zh":u"今天我们学%d新词而复习%d旧词\n需要%d%s%d%s","zh2":u"今天我們學%d新詞而複習%d舊詞\n需要%d%s%d%s"},
"Today we will learn %d words\nThis will require %d %s %d %s\nFollow the spoken instructions carefully":{"zh":u"今天我们学%d新词, 需要%d%s%d%s\n请仔细听从口头指示","zh2":u"今天我們學%d新詞, 需要%d%s%d%s\n請仔細聽從口頭指示"},
"Family mode (multiple user)":{"zh":u"加别的学生(家人等)","zh2":u"加別的學生(家人等)"},
"Add new name":{"zh":u"加名字"},
"Students":{"zh":u"学生","zh2":u"學生"},
"Brief interrupt":{"zh":u"短时暂停","zh2":"短時暫停"},
"Resume":{"zh":u"恢复","zh2":u"恢復"},
"Emergency brief interrupt":{"zh":u"紧急的短打岔","zh2":u"緊急的短打岔"},
"Resuming...":{"zh":u"正在恢复...","zh2":u"正在恢復..."},
"Big print":{"zh":u"大号字体","zh2":u"大號字體"},
"Compressing, please wait":{"zh":u"正在压缩...","zh2":u"正在壓縮..."},
"All recordings have been compressed to MP3.  Do you also want to make a ZIP file for sending as email?":{"zh":u"所有录音都压缩成为MP3了。 你也想做一个ZIP文件所以能随email附上吗?","zh2":u"所有錄音都壓縮成為MP3了。 你也想做一個ZIP文件所以能隨email附上嗎?"},
"Compress all":{"zh":u"压缩这些文件","zh2":u"壓縮這些文件"},
"Play":{"zh":u"播放"},
"Synthesize":{"zh":u"用机器声音","zh2":u"用機器聲音"},
"(synth'd)":{"zh":u"(机器声音)","zh2":u"(機器聲音)"},
"Re-record":{"zh":u"重新录音","zh2":u"重新錄音"},
"(empty)":{"zh":u"(空白)"},
"Record":{"zh":u"录音","zh2":u"錄音"},
"Add more words":{"zh":u"添加词汇","zh2":u"添加詞彙"},
"New folder":{"zh":u"新文件夹","zh2":"新文件夾"},
"Stop":{"zh":u"停止"},
"Action of spacebar during recording":{"zh":u"空格键在录音的时候的功能","zh2":u"空格鍵在錄音的時候的功能"},
"move down":{"zh":u"进步下面"},
"move along":{"zh":u"进步右边","zh2":u"進步右邊"},
"stop":{"zh":u"停止"},
"(Up)":{"zh":u"(返回)"},
"Record from %s":{"zh":u"从%s做录音","zh2":u"從%s做錄音"},
"Record from file":{"zh":u"切已录音的文件","zh2":u"切已錄音的文件"},
"It has been %d days since your last Gradint lesson.  Please try to have one every day.":{"zh":u"你没做Gradint的课%d天了。请试试天天做。","zh2":u"你沒做Gradint的課%d天了。請試試天天做。"},
"It has been %d days since you installed Gradint and you haven't had a lesson yet.  Please try to have one every day.":{"zh":u"%d天前安装了Gradint但还没做课。请试试天天做。","zh2":u"%d天前安裝了Gradint但還沒做課。請試試天天做。"},
"Error: maximum number of new words must be an integer":{"zh":u"误差: 新词界限不是整数","zh2":u"誤差: 新詞界限不是整數"},
"Error: minutes must be a number":{"zh":u"误差: 分钟界限不是号码","zh2":"誤差: 分鐘界限不是號碼"},
"%s new words is a lot to remember at once.  Reduce to 5?":{"zh":u"一天记得%s新词是很多。我减少到5好吗?","zh2":"一天記得%s新詞是很多。我減少到5好嗎?"},
"More than 30 minutes is rarely more helpful.  Reduce to 30?":{"zh":u"超过30分钟很少有帮助。我减少到30好吗?","zh2":"超過30分鐘很少有幫助。我減少到30好嗎?"},
"Less than 20 minutes can be a rush.  Increase to 20?":{"zh":u"缺乏20分钟可以太赶紧了。我增长到20好吗?","zh2":"缺乏20分鐘可以太趕緊了。我增長到20好嗎?"},
"Proceed anyway?":{"zh":u"反正继续?","zh2":"反正繼續"},
"Just speak a word":{"zh":u"使用机器声音说一词","zh2":u"使用機器聲音說一詞"},
"Add word to my vocab":{"zh":u"把词加到词汇表","zh2":u"把詞加到詞彙表"},
"Make lesson from vocab":{"zh":u"做课","zh2":u"做課"},
"Make lesson":{"zh":u"做课","zh2":u"做課"},
"Record word(s) with mic":{"zh":u"从麦克风录音词语","zh2":u"從麥克風錄音詞語"},
    }
scriptVariants = {}
GUI_languages = { "cant":"zh", "zhy":"zh", "zh-yue":"zh" }
GUI_for_editing_only = 0
GUI_omit_settings = 0
GUI_omit_statusline = 0
GUI_always_big_print = 0
recorderMode = 0
runInBackground = 0
useTK = 1
waitBeforeStart = 1
startFunction = None
oss_sound_device = ""
soundVolume = 1
wavPlayer = ""
mp3Player = ""
saveLesson = ""
loadLesson = 0
justSaveLesson = 0
compress_progress_file = 0
paranoid_file_management = 0
once_per_day = 0
disable_once_per_day = 0
macsound = (sys.platform.find("mac")>=0 or sys.platform.find("darwin")>=0)
cygwin = (sys.platform.find("cygwin")>=0)
mingw32 = sys.platform.find("mingw32")>=0
if not macsound and not cygwin and sys.platform.find("win")>=0: import winsound
else: winsound=None
riscos_sound = sys.platform.lower().find("riscos")>=0
try: import olpc
except: olpc = 0
try: import appuifw
except: appuifw = 0
if appuifw:
    appuifw.app.body = appuifw.Text()
    appuifw.app.body.add(u""+program_name.replace("(c)","\n(c)")+"\n\nLoading, please wait...\n(Do NOT press OK or Cancel yet!)\n")
    import audio
    appuifw.app.title = u""+appTitle
    appuifw.app.screen='large' # lose Python banner
    import e32,time
    def e32sleep(s):
        t=time.time()+s
        while time.time()<t:
            check_for_interrupts()
            e32.ao_sleep(min(1,t-time.time()))
    time.sleep = e32sleep
    def s60_interrupt():
        doLabel("Trying to interrupt main thread, please wait...")
        global need_to_interrupt
        need_to_interrupt = 1
    def s60_briefInt():
        global emergency_lessonHold_to
        if emergency_lessonHold_to:
            emergency_lessonHold_to = 0
            doLabel("Resuming...")
        else:
            emergency_lessonHold_to = time.time() + briefInterruptLength
            doLabel("Preparing to interrupt lesson... (select it again to resume)")
    appuifw.app.menu=[(u"Brief interrupt",s60_briefInt),(u"Cancel lesson",s60_interrupt)]
    appuifw.app.exit_key_handler = s60_interrupt
winCEsound = msvcrt = WMstandard = None
if 0: pass # trimmed
if 0: pass # trimmed
if 0: pass # trimmed
try: import androidhelper as android
except:
  try: import android
  except: android = 0
if 0: pass # trimmed
wsp = '\t\n\x0b\x0c\r ' ; bwsp=B(wsp)
warnings_printed = [] ; app = False
warnings_toprint = []
def show_warning(w):
    if w+"\n" in warnings_printed: return
    if not app and not app==False and not appuifw and not android:
        if winCEsound and len(w)>100: w=w[:100]+"..." # otherwise can hang winCEsound's console (e.g. a long "assuming that" message from justSynthesize)
        sys.stderr.write(w+"\n")
    warnings_printed.append(w+"\n")
    if app==False: warnings_toprint.append(w)
def show_info(i,always_stderr=False):
    if (app or appuifw or android) and not always_stderr: return doLabel(i)
    if not riscos_sound and not always_stderr and hasattr(sys.stderr,"isatty") and not sys.stderr.isatty(): return
    if winCEsound and len(i)>101: i=i[:100]+"..."+i[-1]
    if type(i)==type(u""): i=i.encode('utf-8')
    try: writeB(sys.stderr,i)
    except IOError: pass
try: import struct
except: struct=0
if struct and B(struct.pack("h",1)[0])==B('\x00'): big_endian = 1
else: big_endian = 0
if hasattr(os,'extsep'): extsep = os.extsep
else: extsep = "."
dotwav = extsep+"wav" ; dotmp3 = extsep+"mp3" ; dottxt = extsep+"txt"
cwd_addSep = os.sep
if os.getcwd()[-1]==os.sep: cwd_addSep = ""
def list2dict(l):
  d = {}
  for i in l: d[i]=True
  return d
try: list2set = set
except NameError: list2set = list2dict
def checkIn(k,obj):
    try: return k in obj
    except:
        try: return obj.has_key(k)
        except: return obj.find(k) > -1
try: object
except:
    class object: pass
try:
    import os.path
    fileExists = os.path.isfile
    fileExists_stat = os.path.exists
    isDirectory = os.path.isdir
except:
    def fileExists(f):
        try:
            open(f)
            return 1
        except: return 0
    def fileExists_stat(f):
        try:
            os.stat(f)
            return 1
        except: return 0
    def isDirectory(directory):
        oldDir = os.getcwd()
        try:
            os.chdir(directory)
            ret = 1
        except: ret = 0
        os.chdir(oldDir)
        return ret
use_unicode_filenames = winCEsound
if 0: pass # trimmed
def u8strip(d):
    global last_u8strip_found_BOM ; last_u8strip_found_BOM = 0
    d = B(d)
    if d.startswith(LB('\xef\xbb\xbf')):
        last_u8strip_found_BOM = 1
        return d[3:]
    else: return d
def bwspstrip(s):
    try: return s.strip(bwsp)
    except: return s.strip()
def wspstrip(s):
    try: return s.strip(wsp)
    except: return s.strip()
GUI_translations_old = GUI_translations
configFiles = map(lambda x:x+dottxt,["advanced","settings"])
if not hasattr(sys,"argv"): sys.argv=" "
starting_directory = os.getcwd()
if not fileExists(configFiles[0]):
  if macsound and checkIn("_",os.environ):
    s=os.environ["_"] ; s=s[:s.rfind(os.sep)]
    os.chdir(s)
    if not fileExists(configFiles[0]):
        s=s[:s.rfind(os.sep)]
        os.chdir(s)
  if not fileExists(configFiles[0]) and sys.argv and (os.sep in sys.argv[0] or (os.sep=='\\' and '/' in sys.argv[0])):
    if os.sep=="\\" and '/' in sys.argv[0] and fileExists(sys.argv[0].replace('/','\\')): sys.argv[0]=sys.argv[0].replace('/','\\') # hack for some Windows Python builds accepting slash in command line but reporting os.sep as backslash
    os.chdir(starting_directory)
    os.chdir(sys.argv[0][:sys.argv[0].rfind(os.sep)])
  if not fileExists(configFiles[0]):
    os.chdir(starting_directory)
    try: rp = os.path.realpath(sys.argv[0])
    except: rp = 0
    if rp: os.chdir(rp[:rp.rfind(os.sep)])
  if not fileExists(configFiles[0]):
    try: raise 0
    except:
      tbObj = sys.exc_info()[2]
      while tbObj and hasattr(tbObj,"tb_next") and tbObj.tb_next: tbObj=tbObj.tb_next
      if tbObj and hasattr(tbObj,"tb_frame") and hasattr(tbObj.tb_frame,"f_code") and hasattr(tbObj.tb_frame.f_code,"co_filename") and os.sep in tbObj.tb_frame.f_code.co_filename:
        os.chdir(starting_directory)
        try: os.chdir(tbObj.tb_frame.f_code.co_filename[:tbObj.tb_frame.f_code.co_filename.rfind(os.sep)])
        except: pass
if sys.platform.find("ymbian")>-1: sys.path.insert(0,os.getcwd()+os.sep+"lib")
import time,sched,random,math,pprint,codecs
def exc_info(inGradint=True):
    import sys
    w = str(sys.exc_info()[0])
    if "'" in w: w=w[w.index("'")+1:w.rindex("'")]
    if '.' in w: w=w[w.index(".")+1:]
    if sys.exc_info()[1]: w += (": "+str(sys.exc_info()[1]))
    tbObj = sys.exc_info()[2]
    while tbObj and hasattr(tbObj,"tb_next") and tbObj.tb_next: tbObj=tbObj.tb_next
    if tbObj and hasattr(tbObj,"tb_lineno"): w += (" at line "+str(tbObj.tb_lineno))
    if inGradint:
        if tbObj and hasattr(tbObj,"tb_frame") and hasattr(tbObj.tb_frame,"f_code") and hasattr(tbObj.tb_frame.f_code,"co_filename") and not tbObj.tb_frame.f_code.co_filename.find("gradint"+extsep+"py")>=0: w += (" in "+tbObj.tb_frame.f_code.co_filename)
        else: w += (" in "+program_name[:program_name.index(" (c)")])
        w += " on Python "+sys.version.split()[0]+"\n"
    del tbObj
    return w
def read(fname): return open(fname,"rb").read()
def write(fname,data): open(fname,"wb").write(data)
def readSettings(f):
   try: fdat = u8strip(read(f)).replace(B("\r"),B("\n"))
   except: return show_warning("Warning: Could not load "+f)
   try: fdat = unicode(fdat,"utf-8")
   except: return show_warning("Problem decoding utf-8 in "+f)
   try: exec(fdat,globals())
   except: show_warning("Error in "+f+" ("+exc_info(False)+")")
synth_priorities = "eSpeak MacOS SAPI Ekho"
dir1 = list2set(dir()+["dir1","f","last_u8strip_found_BOM","__warningregistry__"])
for f in configFiles: readSettings(f)
for d in dir():
  if not checkIn(d,dir1) and eval(d) and not type(eval(d))==type(lambda *args:0):
    show_warning("Warning: Unrecognised option in config files: "+d)
del dir1
GUI_translations_old.update(GUI_translations) ; GUI_translations = GUI_translations_old
def cond(a,b,c):
    if a: return b
    else: return c
unix = not (winsound or mingw32 or riscos_sound or appuifw or android or winCEsound)
if 0: pass # trimmed
env=os.environ.get("Gradint_Extra_Options","")
while env.endswith(";"): env=env[:-1]
while env.startswith(";"): env=env[1:]
if env: exec(env)
if len(sys.argv)>1:
    runInBackground=0
    progressFileBackup=logFile=None
    exec(" ".join(sys.argv[1:]))
if 0: pass # trimmed
if seedless: random.seed(0)
if 0: pass # trimmed
oldDir=None
for p in [progressFile,progressFileBackup,pickledProgressFile]:
    if not p: continue
    if os.sep in p: p=(p[:p.rfind(os.sep)+1],p[p.rfind(os.sep)+1:])
    else: p=("",p)
    if extsep in p[1]: p=(p[0],p[1][:p[1].rfind(extsep)])
    if oldDir==None: oldDir=p
    elif not oldDir==p:
        sys.stderr.write("ERROR: progressFile, progressFileBackup and pickledProgressFile, if not None, must have same directory and major part of filename.  Gradint will not run otherwise.  This coherence check was added in case some script sets progressFile to something special but forgets to set the others.\n")
        sys.exit(1)
if 0: pass # trimmed
if 0: pass # trimmed
Tk_might_display_wrong_hanzi = wrong_hanzi_message = "" ; forceRadio=0
if 0: pass # trimmed
def progressFileOK():
    try:
        open(progressFile) ; return 1
    except IOError:
        try:
            open(progressFile,"w") ; os.unlink(progressFile)
            return 1
        except: return 0
if 0: pass # trimmed
elif checkIn("HOME",os.environ): tryList=[os.environ["HOME"]+os.sep+"gradint-progress.txt"]
else: tryList = []
foundPF = okPF = 0 ; defaultProgFile = progressFile
while not foundPF:
    if fileExists(progressFile):
        foundPF = okPF = progressFile ; break
    elif (not okPF) and progressFileOK(): okPF = progressFile
    if not tryList: break
    progressFile = tryList.pop()
if foundPF: progressFile=foundPF
elif okPF: progressFile=okPF
else: show_warning("WARNING: Could not find a writable directory for progress.txt and temporary files\nExpect problems!")
need_say_where_put_progress = (not progressFile==defaultProgFile)
if need_say_where_put_progress:
    progressFileBackup = progressFile[:-3]+"bak"
    pickledProgressFile = progressFile[:-3]+"bin"
    logFile = None
tempdir_is_curdir = False
if winsound or winCEsound or mingw32 or riscos_sound or not hasattr(os,"tempnam") or android:
    tempnam_no = 0
    if os.sep in progressFile: tmpPrefix=progressFile[:progressFile.rindex(os.sep)+1]+"gradint-tempfile"
    else: tmpPrefix,tempdir_is_curdir="gradint-tempfile",True
    if 0: pass # trimmed
    def tempnam():
        global tempnam_no ; tempnam_no += 1
        return tmpPrefix+str(tempnam_no)
    os.tempnam = os.tmpnam = tempnam
elif (macsound or sys.platform.lower().find("bsd")>0) and os.environ.get("TMPDIR",""):
    tempnam0 = os.tempnam
    os.tempnam=lambda *args:tempnam0(os.environ["TMPDIR"])
if 0: pass # trimmed
if 0: pass # trimmed
if once_per_day&1 and fileExists(progressFile) and time.localtime(os.stat(progressFile).st_mtime)[:3]==time.localtime()[:3]: sys.exit()
try: orig_onceperday
except: orig_onceperday=0
if 0: pass # trimmed
def got_program(*_): pass # trimmed
def win2cygwin(*_): pass # trimmed
if 0: pass # trimmed
def mysleep(secs):
    if secs>60: secs *= 0.95
    if emulated_interruptMain or winCEsound:
        t=time.time()+secs
        while time.time()<t:
            if emulated_interruptMain: check_for_interrupts()
            if 0: pass # trimmed
            time.sleep(max(0,min(1,t-time.time())))
    else: time.sleep(secs)
emulated_interruptMain = (appuifw or winCEsound)
need_to_interrupt = 0
def check_for_interrupts():
    global need_to_interrupt
    if need_to_interrupt:
        need_to_interrupt = 0
        raise KeyboardInterrupt
if outputFile or justSynthesize or appuifw or not (winsound or winCEsound or mingw32 or macsound or riscos_sound or cygwin or checkIn("DISPLAY",os.environ)): useTK = 0
if useTK and runInBackground and not (winsound or mingw32) and hasattr(os,"fork") and not checkIn("gradint_no_fork",os.environ):
    if os.fork(): sys.exit()
    os.setsid()
    if os.fork(): sys.exit()
    devnull = os.open("/dev/null", os.O_RDWR)
    for fd in range(3): os.dup2(devnull,fd)
else: runInBackground = 0
try: import readline
except: readline=0
try: import cPickle as pickle
except:
  try: import pickle
  except: pickle = None
try: import re
except: re = None
try:
    import gc
    gc.disable()
except: pass
try:
  import locale
  locale.setlocale(locale.LC_ALL, 'C')
except: pass
if not LB('\xc4').lower()==LB('\xc4'):
  lTrans=B("").join([chr(c) for c in range(ord('A'))]+[chr(c) for c in range(ord('a'),ord('z')+1)]+[chr(c) for c in range(ord('Z')+1,256)])
  def lower(s): return s.translate(lTrans)
else:
  def lower(s): return s.lower()
class ProgressDatabase(object):
    def __init__(self,alsoScan=1,fromString=0):
        self.data = [] ; self.promptsData = {}
        self.unavail = [] ; self.saved_completely = 0
        if fromString or not self._load_from_binary():
            self._load_from_text(fromString)
            if self.data and not fromString: self.save_binary(self.data)
        self.oldPromptsData = self.promptsData.copy()
        if alsoScan:
          global is_first_lesson ; is_first_lesson = (not self.data and not self.unavail)
          self.data += self.unavail
          self.unavail = mergeProgress(self.data,scanSamples()+parseSynthVocab(vocabFile))
          if not cache_maintenance_mode:
            doLabel("Checking transliterations")
            global tList
            tList = {}
            def addVs(ff,dirBase):
                dirBase,ff = B(dirBase),B(ff)
                if dirBase: dirBase += B(os.sep)
                if checkIn(dirBase+ff,variantFiles):
                   if B(os.sep) in ff: ffpath=ff[:ff.rfind(B(os.sep))+1]
                   else: ffpath=B("")
                   variantList=map(lambda x,f=ffpath:f+B(x),variantFiles[dirBase+ff])
                else: variantList = [ff]
                l=languageof(ff)
                for f in variantList:
                  f = B(f)
                  if f.lower().endswith(B(dottxt)):
                      text=bwspstrip(u8strip(read(dirBase+f)))
                  elif f.find(B("!synth"))==-1: continue # don't need to translit. filenames of wav's etc
                  else: text = textof(f)
                  if not checkIn(l,tList): tList[l]={}
                  tList[l][text]=1
            for ff in availablePrompts.lsDic.values(): addVs(ff,promptsDirectory)
            for _,l1,l2 in self.data:
                if not type(l1)==type([]): l1=[l1]
                for ff in l1+[l2]: addVs(ff,samplesDirectory)
            doLabel("Transliterating")
            for lang,dic in list(tList.items()):
                s = get_synth_if_possible(lang,0)
                if s and hasattr(s,"update_translit_cache"): s.update_translit_cache(lang,list(dic.keys()))
            del tList
        self.didScan = alsoScan
    def _load_from_binary(self):
        if pickledProgressFile and fileExists(pickledProgressFile):
            if pickle and not (fileExists(progressFile) and os.stat(progressFile)[8] > os.stat(pickledProgressFile)[8]):
                global firstLanguage, secondLanguage, otherLanguages
                if compress_progress_file or (unix and got_program("gzip")):
                    if 0: pass # trimmed
                    f = os.popen('gzip -fdc "'+pickledProgressFile+'"',popenRB)
                else: f=open(pickledProgressFile,"rb")
                try: thingsToSet, tup = pickle.Unpickler(f).load()
                except: return False
                exec(thingsToSet)
                self._py3_fix()
                return True
    def _load_from_text(self,fromString=0):
        if fromString: expr=fromString
        elif fileExists(progressFile):
            if compress_progress_file or (unix and got_program("gzip")):
                if 0: pass # trimmed
                expr = readB(os.popen('gzip -fdc "'+progressFile+'"',popenRB))
            else: expr = read(progressFile)
        else: expr = None
        if expr:
            expr = u8strip(expr).replace(B("\r\n"),B("\n")) # just in case progress.txt has been edited in Notepad
            global firstLanguage, secondLanguage, otherLanguages
            try: self.data = eval(expr)
            except TypeError: raise Exception(progressFile+" has not been properly decompressed") # 'expected string without null bytes'
            except SyntaxError:
                try: import codeop
                except: codeop = 0
                if codeop:
                    lineCache = []
                    for l in expr.replace(B("\r\n"),B("\n")).split(B("\n")):
                        lineCache.append(l)
                        if lineCache[-1].endswith(B(",")): continue # no point trying to compile if it's obviously incomplete
                        code = codeop.compile_command("# coding=utf-8\n"+S(B("\n").join(lineCache)))
                        if code:
                            lineCache = []
                            exec(code)
                else: exec(B("# coding=utf-8\n")+expr)
            del expr
        for k in list(self.promptsData.keys()):
            if k.endswith(dotwav) or k.endswith(dotmp3):
                self.promptsData[k[:-len(dotwav)]]=self.promptsData[k]
                del self.promptsData[k]
        self._py3_fix()
    def _saved_by_py3(self):
        for l in [self.data,self.unavail]:
            for i in l:
                for j in i[1:]:
                    if type(j)==str: j=[j]
                    for k in j:
                        for c in k:
                            if ord(c) > 255: return True
    def _py3_fix(self):
        if not type("")==type(u""): return
        if self._saved_by_py3(): return
        for l in [self.data,self.unavail]:
            for i in range(len(l)):
                for j in [1,2]:
                    if type(l[i][j])==str: l[i]=l[i][:j]+(S2(LB(l[i][j])),)+l[i][j+1:]
                    elif type(l[i][j])==list: l[i]=l[i][:j]+(map(lambda x:S2(LB(x)),l[i][j]),)+l[i][j+1:]
    def _py3_fix_on_save(self):
        if type("")==type(u"") and not self._saved_by_py3(): self.unavail.append((1,u"\u2014","[Py3]")) # ensure there's at least one, to prevent a py3_fix redo
    def save(self,partial=0):
        if need_say_where_put_progress: show_info("Saving "+cond(partial,"partial ","")+"progress to "+progressFile+"... ")
        else: show_info("Saving "+cond(partial,"partial ","")+"progress... ")
        self._py3_fix_on_save()
        global progressFileBackup
        data = []
        for a,b,c in self.data:
            if a: data.append(denumber_filelists(a,b,c))
        sort(data,cmpfunc)
        if progressFileBackup:
            try:
                import shutil
                shutil.copy2(progressFile,progressFileBackup)
            except:
                try: write(progressFileBackup,read(progressFile))
                except IOError: pass
            progressFileBackup = None
        while True:
          try:
            if compress_progress_file:
              if 0: pass # trimmed
              else: fn=progressFile
              f=os.popen('gzip -9 > "'+fn+'"','w')
            else: f = open(progressFile,'w')
            global progressFileHeader
            if type(u"")==type(""): # Python 3: ensure UTF-8
                import codecs
                realF,f = f,codecs.getwriter("utf-8")(f.buffer)
                progressFileHeader=progressFileHeader.replace("mode: python ","mode: python; coding: utf-8")
            else: realF = f
            f.write(progressFileHeader)
            f.write("firstLanguage=\"%s\"\nsecondLanguage=\"%s\"\n# otherLanguages=%s\n" % (firstLanguage,secondLanguage,otherLanguages)) # Note: they're declared "global" above (and otherLanguages commented out here for now, since may add to it in advanced.txt) (Note also save_binary below.)
            if self.didScan and maxNewWords: f.write("# collection=%d done=%d left=%d lessonsLeft=%d\n" % (len(self.data),len(data),len(self.data)-len(data),(len(self.data)-len(data)+maxNewWords-1)/maxNewWords))
            prettyPrintLongList(f,"self.data",data)
            f.write("self.promptsData=") ; pprint.PrettyPrinter(indent=2,width=60,stream=f).pprint(self.promptsData)
            prettyPrintLongList(f,"self.unavail",self.unavail)
            realF.close()
            if compress_progress_file and paranoid_file_management: write(progressFile,read(fn)),os.remove(fn)
            self.save_binary(data)
          except IOError:
            if app or appuifw or android:
              if getYN("I/O fault when saving progress. Retry?"): continue
            else: raise
          break
        if not partial: self.saved_completely = 1
        if not app and not appuifw and not android: show_info("done\n")
    def save_binary(self,data):
        if not (pickledProgressFile and pickle): return
        self._py3_fix_on_save()
        try:
            if compress_progress_file:
              if 0: pass # trimmed
              else: fn=pickledProgressFile
              f=os.popen('gzip -9 > "'+fn+'"',popenWB)
              if hasattr(f,'buffer'): _,f = f,f.buffer
            else: f = open(pickledProgressFile,'wb')
            pickle.Pickler(f,-1).dump(("self.data,self.promptsData,self.unavail,firstLanguage,secondLanguage = tup", (data,self.promptsData,self.unavail,firstLanguage,secondLanguage)))
            f.close()
            if compress_progress_file and paranoid_file_management: write(pickledProgressFile,read(fn)),os.remove(fn)
        except IOError: pass
    def savePartial(self,filesNotPlayed):
        curPD,curDat = self.promptsData, self.data[:]
        self.promptsData = self.oldPromptsData
        if hasattr(self,"previous_filesNotPlayed"):
            i=0
            while i<len(filesNotPlayed):
                if checkIn(filesNotPlayed[i],self.previous_filesNotPlayed): i+=1
                else: del filesNotPlayed[i]
        self.previous_filesNotPlayed = filesNotPlayed = list2set(filesNotPlayed)
        if not filesNotPlayed:
            self.promptsData=curPD
            return self.save()
        changed = 0
        for i in xrange(len(self.data)):
            if type(self.data[i][1])==type([]): l=self.data[i][1][:]
            else: l=[self.data[i][1]]
            l.append(self.data[i][2])
            found=0
            for ii in l:
              if checkIn(ii,filesNotPlayed):
                  self.data[i] = self.oldData[i]
                  found=1 ; break
            if not found and not self.data[i] == self.oldData[i]: changed = 1
        if changed: self.save(partial=1)
        elif app==None and not appuifw and not android: show_info("No sequences were fully complete so no changes saved\n")
        self.promptsData,self.data = curPD,curDat
    def makeLesson(self):
        global maxLenOfLesson
        self.l = Lesson()
        sort(self.data,cmpfunc) ; jitter(self.data)
        self.oldData = self.data[:]
        self.exclude = {} ; self.do_as_poem = {}
        num=self.addToLesson(1,knownThreshold,1,recentInitialNumToTry,maxReviseBeforeNewWords)
        if num < maxReviseBeforeNewWords:
            num += self.addToLesson(knownThreshold,reallyKnownThreshold,1,recentInitialNumToTry,maxReviseBeforeNewWords-num)
            if num < maxReviseBeforeNewWords: self.addToLesson(reallyKnownThreshold,-1,1,1,maxReviseBeforeNewWords-num)
        self.addToLesson(0,0,newWordsTryAtLeast,newInitialNumToTry,maxNewWords)
        self.addToLesson(1,knownThreshold,1,recentInitialNumToTry,-1)
        self.addToLesson(knownThreshold,reallyKnownThreshold,1,recentInitialNumToTry,-1)
        poems, self.responseIndex = find_known_poems(self.data)
        for p in poems:
            for l in p: self.do_as_poem[self.responseIndex[l]] = p
        self.addToLesson(reallyKnownThreshold,-1,1,1,-1)
        if not self.l.events:
            global randomDropLevel, randomDropLevel2
            rdl,rdl2,randomDropLevel,randomDropLevel2 = randomDropLevel,randomDropLevel2,0,0
            self.addToLesson(reallyKnownThreshold,-1,1,1,-1)
            randomDropLevel, randomDropLevel2 = rdl,rdl2
        l = self.l ; del self.l, self.responseIndex, self.do_as_poem
        if not l.events: raise Exception("Didn't manage to put anything in the lesson")
        if commentsToAdd: l.addSequence(commentSequence(),False)
        if orderlessCommentsToAdd:
            for c in orderlessCommentsToAdd:
                try:
                    l.addSequence([GluedEvent(Glue(1,maxLenOfLesson),fileToEvent(c,""))],False)
                except StretchedTooFar:
                    show_info(("Was trying to add %s\n" % (c,)),True)
                    raise
        longpause = "longpause_"+firstLanguage
        if not advancedPromptThreshold and not checkIn(longpause,availablePrompts.lsDic): longpause = "longpause_"+secondLanguage
        o=maxLenOfLesson ; maxLenOfLesson = max(l.events)[0]
        if checkIn(longpause,availablePrompts.lsDic) and self.promptsData.get(longpause,0)==0:
            try:
                def PauseEvent(longpause): return fileToEvent(availablePrompts.lsDic[longpause],promptsDirectory)
                firstPauseMsg = PauseEvent(longpause)
                l.addSequence([GluedEvent(Glue(1,maxLenOfLesson),CompositeEvent([firstPauseMsg,Event(max(5,beepThreshold-firstPauseMsg.length))]))],False)
                while True:
                    l.addSequence([GluedEvent(Glue(1,maxLenOfLesson),CompositeEvent([PauseEvent(longpause),Event(50)]))],False)
                    self.promptsData[longpause] = 1
            except StretchedTooFar: pass
        maxLenOfLesson = o
        try:
            pl=availablePrompts.getPromptList("end",self.promptsData,secondLanguage)
        except PromptException: pl = []
        t,event = max(l.events)
        t += event.length
        for p in pl:
            end_event = fileToEvent(p,promptsDirectory)
            l.events.append((t,end_event))
            t += end_event.length
        if not pl and fileExists(promptsDirectory+os.sep+"end"+dotwav):
            l.events.append((t,SampleEvent(promptsDirectory+os.sep+"end"+dotwav)))
            show_warning("Warning: Using legacy end"+dotwav+" - please change it to end_"+firstLanguage+dotwav+" and end_"+secondLanguage+dotwav+" (or "+extsep+"txt if you have synthesis)")
        l.cap_max_lateness()
        return l
    def addToLesson(self,minTimesDone=0,maxTimesDone=-1,minNumToTry=0,maxNumToTry=0,maxNumToAdd=-1):
        if maxNumToAdd==None: return 0
        numberAdded = 0
        newWordTimes = {}
        for numToTry in range(maxNumToTry,minNumToTry-1,-1):
            numFailures = 0 ; startTime = time.time()
            for i in xrange(len(self.data)):
                if maxNumToAdd>-1 and numberAdded >= maxNumToAdd: break
                if checkIn(i,self.exclude): continue
                (timesDone,promptFile,zhFile)=self.data[i]
                if timesDone < minTimesDone or (maxTimesDone>=0 and timesDone > maxTimesDone): continue
                if timesDone >= knownThreshold: thisNumToTry = min(random.choice([2,3,4]),numToTry)
                else: thisNumToTry = numToTry
                if timesDone >= randomDropThreshold and random.random() <= calcDropLevel(timesDone):
                    self.exclude[i] = 1
                    continue
                if checkIn(i,self.do_as_poem):
                    self.try_add_poem(self.do_as_poem[i]) ; continue
                oldPromptsData = self.promptsData.copy()
                seq=anticipationSequence(promptFile,zhFile,timesDone,timesDone+thisNumToTry,self.promptsData,introductions(zhFile,self.data))
                seq[0].timesDone = timesDone
                global earliestAllowedEvent ; earliestAllowedEvent = 0
                if not timesDone and type(promptFile)==type([]):
                    for f,t in list(newWordTimes.items()):
                        if checkIn(f,promptFile): earliestAllowedEvent = max(earliestAllowedEvent,t)
                if not timesDone: newWordTimes[zhFile] = maxLenOfLesson
                try: self.l.addSequence(seq)
                except StretchedTooFar:
                    earliestAllowedEvent = 0
                    self.promptsData = oldPromptsData
                    numFailures += 1
                    if numFailures > 2 and time.time()>startTime+1:
                        break
                    else: continue
                except IOError:
                    show_warning("Excluding %s (problems reading)" % str(zhFile))
                    earliestAllowedEvent = 0
                    self.exclude[i] = 1
                    continue
                numFailures = 0
                earliestAllowedEvent = 0
                numberAdded = numberAdded + 1
                self.exclude[i] = 1
                if not timesDone: self.l.newWords += 1
                else: self.l.oldWords += 1
                self.data[i]=(timesDone+thisNumToTry,promptFile,zhFile)
                if not timesDone: newWordTimes[zhFile] = seq[0].getEventStart(0)
        return numberAdded
    def try_add_poem(self,poem):
        poemSequence = []
        isPrefix=0
        while not isPrefix: i,isPrefix = randomInstruction(2,self.promptsData,languageof(poem[0]))
        poemSequence.append(filesToEvents(i,promptsDirectory))
        poemSequence.append(fileToEvent(poem[0]))
        for line in poem:
            e=fileToEvent(line)
            poemSequence.append(Event(e.length))
            poemSequence.append(e)
            self.exclude[self.responseIndex[line]] = 1
        poemSequence = [GluedEvent(initialGlue(),CompositeEvent(poemSequence))]
        poemSequence[0].endseq = False
        try: self.l.addSequence(poemSequence)
        except StretchedTooFar: return
        self.l.oldWords += 1
        for line in poem: self.data[self.responseIndex[line]]=(self.data[self.responseIndex[line]][0]+1,)+self.data[self.responseIndex[line]][1:]
    def veryExperienced(self):
        x = getattr(self,'cached_very_experienced',None)
        if x==None:
            covered = 0
            for timesDone,promptFile,zhFile in self.data:
                if timesDone: covered += 1
            x = (covered > veryExperiencedThreshold)
            self.cached_very_experienced = x
        return x
    def message(self):
        covered = 0 ; total = len(self.data)
        actualCovered = 0 ; actualTotal = 0
        for timesDone,promptFile,zhFile in self.data:
            if timesDone:
                covered += 1
                if B(zhFile).find(B(exclude_from_coverage))==-1: actualCovered += 1
            if B(zhFile).find(B(exclude_from_coverage))==-1: actualTotal += 1
        l=cond(app,localise,lambda x:x)
        toRet = (l("You have %d words in your collection") % total)
        if not total==actualTotal: toRet += (" (actually %d)" % actualTotal)
        if covered:
            toRet += ("\n("+(l("%d new words + %d old words") % (total-covered,covered))+")")
            if not covered==actualCovered: toRet += (" (actually %d new %d old)" % (actualTotal-actualCovered,actualCovered))
        return toRet
def prettyPrintLongList(f,thing,data):
    step = 50
    if 0: pass # trimmed
    else: p=pprint.PrettyPrinter(indent=2,width=60,stream=f)
    for start in range(0,len(data),step):
        dat = data[start:start+step]
        if type("")==type(u""): # Python 3: probably best to output strings rather than bytes
            for i in range(len(dat)):
                for j in [1,2]:
                    if type(dat[i][j])==bytes:
                        dat[i]=dat[i][:j]+(S2(dat[i][j]),)+dat[i][j+1:]
                    elif type(dat[i][j])==list:
                        dat[i]=dat[i][:j]+(map(S2,dat[i][j]),)+dat[i][j+1:]
        if start: f.write(thing+"+=")
        else: f.write(thing+"=")
        if p:
            t = time.time()
            p.pprint(dat)
            if not start and (time.time()-t)*(len(data)/step) > 5: p=0
        else:
            f.write("[")
            for d in dat: f.write("  "+repr(d)+",\n")
            f.write("]\n")
def calcDropLevel(timesDone):
    if timesDone > randomDropThreshold2:
        return randomDropLevel2
    return dropLevelK * timesDone + dropLevelC
try:
    dropLevelK = (randomDropLevel2-randomDropLevel)/(randomDropThreshold2-randomDropThreshold)
    dropLevelC = randomDropLevel-dropLevelK*randomDropThreshold
except ZeroDivisionError:
    dropLevelK = 0
    dropLevelC = randomDropLevel
def cmpfunc(x,y):
    r = cmpfunc_test(x[0],y[0])
    if r: return r
    if x[0]: return cmpfunc_test(x,y)
    def my_toString(x):
        if type(x)==type([]): return B("").join(map(B,x))
        else: return B(x)
    x2 = (my_toString(x[1]).replace(B(os.sep),chr(0)), my_toString(x[2]).replace(B(os.sep),chr(0)))
    y2 = (my_toString(y[1]).replace(B(os.sep),chr(0)), my_toString(y[2]).replace(B(os.sep),chr(0)))
    return cmpfunc_test(x2,y2)
def cmpfunc_test(x,y):
    try:
        if x < y: return -1
        elif x > y: return 1
        else: return 0
    except:
        if x[0] < y[0]: return -1
        elif x[0] > y[0]: return 1
        x,y = repr(x),repr(y)
        if x < y: return -1
        elif x > y: return 1
        else: return 0
def denumber_filelists(r,x,y):
    if type(x)==type([]): x=map(lambda z:denumber_synth(z),x)
    else: x=denumber_synth(x)
    if type(y)==type([]): y=map(lambda z:denumber_synth(z),y)
    else: y=denumber_synth(y)
    return (r,x,y)
def denumber_synth(z,also_norm_extsep=0):
    z=B(z) ; zf = z.find(B("!synth:"))
    if zf>=0:
        z=lower(z[zf:])
        if z.endswith(B(dotwav)) or z.endswith(B(dotmp3)): return z[:z.rindex(B(extsep))]
    elif also_norm_extsep: return z.replace(B("\\"),B("/")).replace(B("."),B("/")) # so compares equally across platforms with os.sep and extsep differences
    return z
def norm_filelist(x,y):
    def noext(x): return (B(x)+B(' '))[:B(x).rfind(B(extsep))] # so user can change e.g. wav to mp3 without disrupting progress.txt (the ' ' is simply removed if rfind returns -1)
    if type(x)==type([]): x=tuple(map(lambda z,noext=noext:denumber_synth(noext(z),1),x))
    else: x=denumber_synth(noext(x),1)
    if type(y)==type([]): y=tuple(map(lambda z,noext=noext:denumber_synth(noext(z),1),y))
    else: y=denumber_synth(noext(y),1)
    return (x,y)
def mergeProgress(progList,scan):
    proglistDict = {} ; scanlistDict = {} ; n = 0
    while n<len(progList):
        i,j,k = progList[n]
        if i:
            proglistDict[norm_filelist(j,k)]=n
            n += 1
        else: del progList[n]
    renames = {}
    for (_,j,k) in scan:
        key = norm_filelist(j,k)
        if checkIn(key,proglistDict):
            progList[proglistDict[key]]=(progList[proglistDict[key]][0],j,k)
        elif type(key[0])==type("") and (key[0]+key[1]).find("!synth")==-1 and ("_" in key[0] and "_" in key[1]):
            normK = key[1]
            lastDirsep = normK.rfind(os.sep)
            ki = len(normK)-1 ; found=0
            while ki>lastDirsep:
                while ki>lastDirsep and not "0"<=normK[ki]<="9": ki -= 1
                if ki<=lastDirsep: break
                key2 = (key[0][:ki+1]+key[0][key[0].rindex("_"):],key[1][:ki+1]+key[1][key[1].rindex("_"):])
                if checkIn(key2,proglistDict):
                    if not checkIn(key2,renames): renames[key2] = []
                    renames[key2].append((j,k))
                    found=1 ; break
                while ki>lastDirsep and "0"<=normK[ki]<="9": ki -= 1
            if not found: progList.append((0,j,k))
        else: progList.append((0,j,k))
        scanlistDict[key]=1
    for k,v in list(renames.items()):
        if checkIn(k,scanlistDict) or len(v)>1:
            for jj,kk in v: progList.append((0,jj,kk))
        else: progList[proglistDict[k]]=(progList[proglistDict[k]][0],v[0][0],v[0][1])
    n = 0 ; unavailList = []
    while n<len(progList):
        i,j,k = progList[n]
        if not checkIn(norm_filelist(j,k), scanlistDict):
            unavailList.append((i,j,k))
            del progList[n]
        else: n += 1
    return unavailList
def jitter(list):
#     swappedLast = 0
#     for i in range(len(list)-1):
#         if list[i][0] and ((list[i][0] == list[i+1][0] and random.choice([1,2])==1) or (not list[i][0] == list[i+1][0] and random.choice([1,2,3,4,5,6])==1 and not swappedLast)):
#             x = list[i]
#             del list[i]
#             list.insert(i+1,x)
#             swappedLast = 1
#         else: swappedLast = 0
    i = 0 ; groupStart = -1
    while i <= len(list):
        if i<len(list) and not list[i][0]: pass
        elif i<len(list) and groupStart<0:
            groupStart = i
            try:
                incrementThreshold = int(math.exp(list[groupStart][0]*shuffleConstant/(randomDropThreshold+1)-shuffleConstant))
            except OverflowError: incrementThreshold=sys.maxint
        elif groupStart>=0 and (i==len(list) or list[i][0] - list[groupStart][0] > incrementThreshold):
            l2 = list[groupStart:i] ; random.shuffle(l2)
            del list[groupStart:i]
            for item in l2: list.insert(groupStart,item)
            groupStart = -1
            continue
        i += 1
    limitCounts = {} ; i = 0 ; imax = len(list)
    while i < imax:
        if list[i][0]==0 and checkIn(list[i][-1],limitedFiles):
            countNo = limitedFiles[list[i][-1]]
            if not checkIn(countNo,limitCounts): limitCounts [countNo] = 0
            limitCounts [countNo] += 1
            if limitCounts [countNo] > cond(imax==len(list),limit_words,1) or (countNo=="other-langs" and limitCounts [countNo] > 1):
                list.append(list[i])
                del list[i]
                imax -= 1
                continue
        i += 1
def find_known_poems(progressData):
    nextLineDic = {}
    responseIndex = {}
    hasPreviousLine = {}
    for i in xrange(len(progressData)):
        response = progressData[i][2]
        responseIndex[response] = i
        if type(progressData[i][1])==type([]): line=progressData[i][1][cond(len(progressData[i][1])==2,0,-1)]
        else: line=progressData[i][1]
        if languageof(line)==languageof(response) and not line==response:
            nextLineDic[line]=response
            hasPreviousLine[response]=True
    poems = []
    for poemFirstLine in filter(lambda x,hasPreviousLine=hasPreviousLine:not x in hasPreviousLine,nextLineDic.keys()):
        poemLines = [] ; line = poemFirstLine
        poem_is_viable = True
        while True:
            poemLines.append(line)
            if not checkIn(line,responseIndex) or progressData[responseIndex[line]][0] < reallyKnownThreshold:
                poem_is_viable = False ; break
            if not checkIn(line,nextLineDic): break
            line = nextLineDic[line]
        if poem_is_viable: poems.append(poemLines)
    return poems, responseIndex
def randomInstruction(numTimesBefore,promptsData,language):
    if not numTimesBefore: return (availablePrompts.getPromptList("repeatAfterMe",promptsData,language),0)
    if numTimesBefore==1: return (availablePrompts.getPromptList("sayAgain",promptsData,language),1)
    if (dbase.veryExperienced() and numTimesBefore>=reallyKnownThreshold) or (meaningTestThreshold and numTimesBefore>meaningTestThreshold and not random.choice([1,2,3])==1):
        if language==secondLanguage: return (None,1)
        else: return (availablePrompts.getPromptList(language,promptsData,language),1)
    r = availablePrompts.getRandomPromptList(promptsData,language)
    for i in r:
        if i.startswith("whatSay_"): return (r,0)
    return (r,1)
def anticipation(promptFile,zhFile,numTimesBefore,promptsData):
    instructions, instrIsPrefix = randomInstruction(numTimesBefore,promptsData,languageof(zhFile))
    if instructions: instructions = map(lambda x:fileToEvent(x,promptsDirectory), instructions)
    else: instructions = [Event(1)]
    zhEvent = filesToEvents(zhFile) ; secondPause = 1+zhEvent.length
    promptEvent = filesToEvents(promptFile)
    if not numTimesBefore: anticipatePause = 1
    else: anticipatePause = secondPause
    first_repeat_is_unessential = 0
    if not numTimesBefore:
        numVariants = min(3,len(variantFiles.get(B(samplesDirectory)+B(os.sep)+B(zhFile),[0])))
        if numVariants>1 and lessonIsTight(): numVariants = 1
        numRepeats = numVariants + cond(numVariants>=cond(availablePrompts.user_is_advanced,2,3),0,1)
    elif numTimesBefore == 1: numRepeats = 3
    elif numTimesBefore < 5: numRepeats = 2
    elif numTimesBefore < 10:
        numRepeats = random.choice([1,2])
        if numRepeats==2: first_repeat_is_unessential = 1
    else: numRepeats = 1
    if numRepeats==1:
      k,f = synthcache_lookup(zhFile,justQueryCache=1)
      if f and B(k[:1])==B("_") and not checkIn(textof(zhFile),subst_synth_counters):
        c=random.choice([1,2,3])
        if c==1: pass
        elif c==2:
            numRepeats = 2
            first_repeat_is_unessential = 1
        elif c==3: subst_synth_counters[textof(zhFile)]=1
    theList = []
    if instrIsPrefix: theList = instructions
    theList.append(promptEvent)
    if promptFile==zhFile and not checkIn(promptFile,singleLinePoems):
        theList = theList + map(lambda x:fileToEvent(x,promptsDirectory), availablePrompts.getPromptList("begin",promptsData,languageof(zhFile)))
    if not instrIsPrefix: theList += instructions
    origZhEvent = zhEvent
    for i in range(numRepeats):
        if i:
            zhEvent = filesToEvents(zhFile)
            secondPause = 1+zhEvent.length
        theList.append(Event(anticipatePause))
        if i==1 and first_repeat_is_unessential: theList[-1].importance,theList[-1].max_lateness = 0,1
        theList.append(zhEvent)
        if i==0 and first_repeat_is_unessential:
            theList[-1].setOnLeaves('max_lateness',1) # the 1st repetition itself
            theList[-1].setOnLeaves('wordToCancel','') # so it doesn't register as needing to cancel anything
            theList[-1].setOnLeaves('importance',0) # and doesn't try to cap the max lateness of earlier events
        anticipatePause = secondPause
    theList.append(Event(1))
    extraPauseAfter = random.choice([0,1,2])
    if extraPauseAfter:
        theList.append(Event(extraPauseAfter))
        theList[-1].importance,theList[-1].max_lateness = 0,1
    if not numTimesBefore:
        explanation = explanations(zhFile)
        if explanation:
            theList.insert(1,origZhEvent)
            theList.insert(1,explanation)
            theList.insert(1,origZhEvent)
    return CompositeEvent(theList)
def reverseAnticipation(promptFile,zhFile,promptsData):
    zhEvent = filesToEvents(zhFile)
    promptEvent = filesToEvents(promptFile)
    theList = []
    theList.append(zhEvent)
    for p in availablePrompts.getPromptList("whatmean",promptsData,languageof(zhFile)): theList.append(fileToEvent(p,promptsDirectory))
    theList.append(Event(1))
    for p in availablePrompts.getPromptList("meaningis",promptsData,languageof(zhFile)): theList.append(fileToEvent(p,promptsDirectory))
    theList.append(promptEvent)
    theList.append(Event(random.choice([1,2,3])))
    return CompositeEvent(theList)
def languageof(file):
    file = B(file)
    assert B("_") in file, "no _ in %s" % (repr(file),)
    s=file[file.rindex(B("_"))+1:]
    if B(extsep) in s: return S(s[:s.rindex(B(extsep))])
    else: return S(s)
def commentSequence():
    sequence = []
    for c in commentsToAdd:
        sequence.append(GluedEvent(Glue(1,maxLenOfLesson),fileToEvent(c,"")))
    return sequence
def anticipationSequence(promptFile,zhFile,start,to,promptsData,introList):
    sequence = []
    if meaningTestThreshold and to==start+1 and start>meaningTestThreshold and random.choice([1,2])==1 and not type(promptFile)==type([]) and B(promptFile).find(B("_"+firstLanguage+extsep))>=0:
        firstItem = reverseAnticipation(promptFile,zhFile,promptsData)
    else: firstItem = anticipation(promptFile,zhFile,start,promptsData)
    if introList: firstItem=CompositeEvent(introList+[firstItem])
    sequence.append(GluedEvent(initialGlue(),firstItem))
    for i in range(start+1,to):
        sequence.append(GluedEvent(glueBefore(i),anticipation(promptFile,zhFile,i,promptsData)))
    return sequence
def glueBefore(num):
    global is_first_lesson
    if is_first_lesson and num==1 and not is_first_lesson=="hadGlue":
        is_first_lesson = "hadGlue"
        return Glue(27,3)
    if num==0: return initialGlue()
    elif num==1: return Glue(15,15)
    elif num==2: return Glue(45,15)
    elif num==3: return Glue(130,30)
    elif num==4: return Glue(500,60)
    else: return Glue(500,150+3*(num-5))
randomAdjustmentThreshold = 500
def doOneLesson(dbase):
    global saveLesson
    if dbase:
        soFar = dbase.message()
        lesson = dbase.makeLesson()
    else:
        soFar = "Re-loading saved lesson, so not scanning collection."
        if compress_progress_file:
            pp = os.popen('gzip -fdc "'+saveLesson+'"',popenRB)
            if hasattr(pp,'buffer'): ppb = pp.buffer
            else: ppb = pp
            lesson=pickle.Unpickler(ppb).load()
            del ppb,pp
        else: lesson=pickle.Unpickler(open(saveLesson,'rb')).load()
    if app and not dbase: app.setNotFirstTime()
    while 1:
      global cancelledFiles ; cancelledFiles = []
      global askAgain_explain ; askAgain_explain = ""
      if not justSaveLesson:
        if emulated_interruptMain: check_for_interrupts()
        msg = soFar+"\n"+lesson.message() # +"\n(When you continue, there will be a 5 second delay\nto sit comfortably)"
        if waitBeforeStart:
            waitOnMessage(msg+interrupt_instructions())
            time.sleep(2)
        elif not app and not appuifw and not android: show_info(msg+interrupt_instructions()+"\n",True)
        if startFunction: startFunction()
        if 0: pass # trimmed
        lesson.play()
      if not gluedListTracker==None:
          global lastLessonMade ; lastLessonMade = lesson
      if dbase and saveProgress and not dbase.saved_completely:
          if cancelledFiles: dbase.savePartial(cancelledFiles)
          else: dbase.save()
          if dbase.saved_completely and app: app.setNotFirstTime()
          if saveLesson:
              if compress_progress_file:
                  pp = os.popen('gzip -9 > "'+saveLesson+'"',popenWB)
                  if hasattr(pp,'buffer'): ppb=pp.buffer
                  else: ppb = pp
                  pickle.Pickler(ppb,-1).dump(lesson)
                  del ppb,pp
              else: pickle.Pickler(open(saveLesson,"wb"),-1).dump(lesson)
              saveLesson = None
              if justSaveLesson: break
      if not app and not app==None: break
      if not waitBeforeStart or not getYN(cond(not askAgain_explain and (not dbase or not saveProgress or dbase.saved_completely),"Hear this lesson again?",askAgain_explain+"Start this lesson again?")): break
def disable_lid(*_): pass # trimmed
if loadLesson==-1: loadLesson=(fileExists(saveLesson) and time.localtime(os.stat(saveLesson).st_mtime)[:3]==time.localtime()[:3])
def lesson_loop():
  global app,availablePrompts,teacherMode
  if ask_teacherMode and not soundCollector and waitBeforeStart: teacherMode=getYN("Use teacher assistant mode? (say 'no' for self-study)")
  try:
    init_scanSamples()
    availablePrompts = AvailablePrompts()
    global dbase
    if loadLesson: dbase=None
    else:
        doLabel("Loading progress data")
        dbase = ProgressDatabase()
        if not dbase.data:
            msg = "There are no words to put in the lesson."
            if app or appuifw or android:
                drop_to_synthloop = False
                msg = localise(msg)+"\n"+localise("Please add some words first.")
            else:
                drop_to_synthloop = (synth_partials_voices or get_synth_if_possible("en",0) or viable_synths)
                msg += "\nPlease read the instructions on the website\nwhich tell you how to add words.\n"+cond(drop_to_synthloop,"Dropping back to justSynthesize loop.\n","")
            if drop_to_synthloop:
                clearScreen() ; show_info(msg)
                primitive_synthloop()
            else: waitOnMessage(msg)
            return
    doLabel("Making lesson")
    doOneLesson(dbase)
  finally: teacherMode=0
def initialGlue(): return Glue(0,maxLenOfLesson)
try: from bisect import insort
except:
    def insort(l,item):
        l.append(item) ; l.sort()
class Schedule(object):
    def __init__(self): self.bookedList = []
    def book(self,start,finish): insort(self.bookedList,(start,finish))
earliestAllowedEvent = 0
class GlueOrEvent(object):
    def __init__(self,length=0,plusMinus=0,invisible=0):
        self.length = length
        self.plusMinus = plusMinus
        self.invisible = invisible
    def makesSenseToLog(self): return 0
    def bookIn(self,schedule,start):
        if not self.invisible:
            schedule.book(start,start+self.length)
    def addToEvents(self,events,startTime):
        assert not self.invisible
        events.append((startTime,self))
    def overlaps(self,start,schedule,direction):
        if self.invisible: return 0
        if not schedule.bookedList: return 0
        oldStart = start
        if direction==1:
            start = max(start,earliestAllowedEvent)
            count = 0 ; blLen = len(schedule.bookedList)
            while count<blLen and schedule.bookedList[count][1] <= start:
                count += 1
            while count<blLen and schedule.bookedList[count][0]<start+self.length:
                start = schedule.bookedList[count][1]
                count += 1
            return start-oldStart
        else:
            if start<earliestAllowedEvent: return oldStart+1
            count = len(schedule.bookedList)-1
            finish=start+self.length
            while count>=0 and schedule.bookedList[count][0] >= finish:
                count -= 1
            while count>=0 and schedule.bookedList[count][1]>start:
                start = schedule.bookedList[count][0]-self.length
                count -= 1
            return oldStart-start
    def will_be_played(self): pass
    def play(self): pass
    def setOnLeaves(self,name,value):
        if not hasattr(self,name): exec('self.'+name+'='+repr(value))
    def setOnLastLeaf(self,name,value): self.setOnLeaves(name,value)
class Event (GlueOrEvent):
    def __init__(self,length):
        GlueOrEvent.__init__(self,length)
    def play(self):
        if 0: pass # trimmed
        else: mysleep(min(3,self.length*0.7))
class CompositeEvent (Event):
    def __init__(self,eventList):
        length = 0
        for i in eventList: length += i.length
        Event.__init__(self,length)
        self.eventList = eventList
    def addToEvents(self,events,startTime):
        for i in self.eventList:
            i.addToEvents(events,startTime)
            startTime = startTime + i.length
    def play(self):
        for e in self.eventList: e.play()
    def setOnLeaves(self,name,value):
        for e in self.eventList: e.setOnLeaves(name,value)
    def setOnLastLeaf(self,name,value): self.eventList[-1].setOnLastLeaf(name,value)
    def makesSenseToLog(self):
        if hasattr(self,"is_prompt"): return not self.is_prompt
        for e in self.eventList:
            if e.makesSenseToLog(): return True
    def __repr__(self): return "{"+(" ".join([str(e) for e in self.eventList]))+"}"
class Glue (GlueOrEvent):
    def __init__(self,length,plusMinus):
        GlueOrEvent.__init__(self,length,plusMinus,1)
def sgn(a): return [1,-1][a<0]
class StretchedTooFar(Exception): pass
class GluedEvent(object):
    def __init__(self,glue,event):
        self.glue = glue
        self.event = event
        self.glue.adjustment = 0
        self.glue.preAdjustment = None
    def randomPreAdjustment(self):
        if self.glue.length < randomAdjustmentThreshold: self.glue.preAdjustment = 0
        elif is_first_lesson:
            self.glue.preAdjustment = random.gauss(0,self.glue.plusMinus)
            if self.glue.preAdjustment<0: self.glue.preAdjustment = - self.glue.preAdjustment
            if self.glue.preAdjustment > self.glue.plusMinus: self.glue.preAdjustment = 0
            self.glue.preAdjustment -= self.glue.plusMinus
        else:
            self.glue.preAdjustment = random.gauss(0,self.glue.plusMinus)
            if abs(self.glue.preAdjustment) > self.glue.plusMinus:
                self.glue.preAdjustment = self.glue.plusMinus
    def adjustGlue(self,glueStart,schedule,direction):
        needMove = self.event.overlaps(glueStart+self.glue.length+self.glue.preAdjustment,schedule,direction)
        needMove=needMove*direction+self.glue.preAdjustment
        direction=sgn(needMove) ; needMove=abs(needMove)
        if needMove > self.glue.plusMinus \
           or (direction<0 and needMove > self.glue.length)\
           or glueStart+self.glue.length+needMove*direction+self.event.length > maxLenOfLesson:
            raise StretchedTooFar()
        self.glue.adjustment = needMove * direction
    def getAdjustedEnd(self,glueStart):
        return glueStart+self.glue.length+self.glue.adjustment+self.event.length
    def bookIn(self,schedule,glueStart):
        self.event.bookIn(schedule,glueStart+self.glue.length+self.glue.adjustment)
    def getEventStart(self,glueStart):
        return glueStart+self.glue.length+self.glue.adjustment
    def setOnLeaves(self,name,value): self.event.setOnLeaves(name,value)
    def setOnLastLeaf(self,name,value): self.event.setOnLastLeaf(name,value)
def setGlue(gluedEventList, schedule, glueStart = 0):
    if not gluedEventList: return
    try:
        if gluedEventList[0].glue.preAdjustment==None: gluedEventList[0].randomPreAdjustment()
        gluedEventList[0].adjustGlue(glueStart,schedule,1)
        setGlue(gluedEventList[1:],schedule,gluedEventList[0].getAdjustedEnd(glueStart))
    except StretchedTooFar:
        if glueStart==0: raise StretchedTooFar
        gluedEventList[0].adjustGlue(glueStart,schedule,-1)
        setGlue(gluedEventList[1:],schedule,gluedEventList[0].getAdjustedEnd(glueStart))
def setGlue_wrapper(gluedEventList, schedule):
    if len(gluedEventList)==1: return setGlue(gluedEventList,schedule)
    worked = 0
    while (not worked) and gluedEventList[0].glue.length < maxLenOfLesson:
        try:
            setGlue(gluedEventList, schedule)
            worked = 1
        except StretchedTooFar:
            gluedEventList[0].glue.length += (10+gluedEventList[0].glue.adjustment)
    if not worked: raise StretchedTooFar()
def bookIn(gluedEventList,schedule):
    setGlue_wrapper(gluedEventList,schedule)
    glueStart = 0
    for i in gluedEventList:
        i.bookIn(schedule,glueStart)
        glueStart = i.getAdjustedEnd(glueStart)
gluedListTracker=None
class Lesson(object):
    def __init__(self):
        self.schedule = Schedule()
        self.events = []
        self.newWords = self.oldWords = 0
        self.eventListCounter = 0
        if startAnnouncement:
            w = fileToEvent(startAnnouncement,"")
            w.bookIn(self.schedule,0)
            w.addToEvents(self.events,0)
        if endAnnouncement:
            w = fileToEvent(endAnnouncement,"")
            wStart = maxLenOfLesson-w.length
            w.bookIn(self.schedule,wStart)
            w.addToEvents(self.events,wStart)
    def message(self):
        t,event = max(self.events)
        finish = int(0.5+t+event.length)
        teacher_extra = ""
        if teacherMode:
            self.events.sort()
            for t,event in self.events:
                if event.makesSenseToLog():
                    teacher_extra="\nFirst word will be "+maybe_unicode(str(event))
                    break
        l=cond(app,localise,lambda x:x)
        if self.oldWords or teacherMode:
            return l("Today's lesson teaches %d new words\nand revises %d old words\n\nPlaying time: %d %s %d %s") % (self.newWords,self.oldWords,finish/60,singular(finish/60,"minutes"),finish%60,singular(finish%60,"seconds"))+teacher_extra
        else:
            return l("Today we will learn %d words\nThis will require %d %s %d %s\nFollow the spoken instructions carefully") % (self.newWords,finish/60,singular(finish/60,"minutes"),finish%60,singular(finish%60,"seconds"))
    def addSequence(self,gluedEventList,canTrack=True):
        bookIn(gluedEventList,self.schedule)
        if not gluedListTracker==None and canTrack: gluedListTracker.append(gluedEventList)
        glueStart = 0 ; lastI = None
        for i in gluedEventList:
            i.event.setOnLeaves("sequenceID",self.eventListCounter)
            i.event.setOnLeaves("importance",len(gluedEventList))
            startTime = i.getEventStart(glueStart)
            i.event.addToEvents(self.events,startTime)
            glueStart = i.getAdjustedEnd(glueStart)
            if lastI: lastI.event.setOnLeaves("max_lateness",max(1,10/len(gluedEventList))+min(lastI.glue.plusMinus-lastI.glue.adjustment,i.glue.plusMinus+i.glue.adjustment))
            lastI = i
        if lastI:
            lastI.event.setOnLeaves("max_lateness",max(1,10/len(gluedEventList))+lastI.glue.plusMinus-lastI.glue.adjustment)
            if hasattr(gluedEventList[0],"timesDone"): lastI.event.setOnLastLeaf("endseq",not gluedEventList[0].timesDone)
        self.eventListCounter += 1
    def cap_max_lateness(self):
        self.events.sort() ; self.events.reverse()
        latenessCap = {} ; nextStart = 0
        for t,event in self.events:
            if nextStart:
                for k in list(latenessCap.keys()): latenessCap[k] += (nextStart-(t+event.length))
            nextStart = t
            if not hasattr(event,"importance"): continue # (wasn't added via addSequence, probably not a normal lesson)
            event.max_lateness=min(event.max_lateness,latenessCap.get(event.importance,maxLenOfLesson))
            for i in range(event.importance): latenessCap[i]=min(latenessCap.get(i,maxLenOfLesson),event.max_lateness)
            del event.importance
        self.events.reverse()
    def play(self):
        if (synthCache_test_mode or synthCache_test_mode==[]) and not hasattr(self,"doneSubst"):
            subst_some_synth_for_synthcache(self.events)
            self.doneSubst=1
        global runner, finishTime, lessonLen, wordsLeft
        wordsLeft={False:self.oldWords,True:self.newWords}
        initLogFile()
        for (t,event) in self.events: event.will_be_played()
        if 0: pass # trimmed
        finishTime = None
        if self.events:
            lessonLen = self.events[-1][0]+self.events[-1][1].length
            if lessonLen>60:
                finishTime = int(0.5+(time.time() + lessonLen))
                if (riscos_sound or winCEsound) and not app and not soundCollector: show_info("Started at %s, will finish at %s\n" % (time.strftime("%H:%M",time.localtime(time.time())),time.strftime("%H:%M",time.localtime(finishTime))))
        global sequenceIDs_to_cancel ; sequenceIDs_to_cancel = {}
        global copy_of_runner_events ; copy_of_runner_events = []
        global lessonStartTime ; lessonStartTime = 0
        disable_lid(0)
        try:
          if 0: pass # trimmed
          else: runner = sched.scheduler(time.time,mysleep)
          for (t,event) in self.events: copy_of_runner_events.append((event,runner.enter(t,1,play,(event,)),t))
          try: runner.run()
          except KeyboardInterrupt: handleInterrupt()
        finally: disable_lid(1)
        runner = None
        if 0: pass # trimmed
        if logFileHandle: logFileHandle.close()
subst_synth_counters = {}
def decide_subst_synth(cache_fname):
    subst_synth_counters[cache_fname] = subst_synth_counters.get(cache_fname,0)+1
    return subst_synth_counters[cache_fname] in [2,4] or (subst_synth_counters[cache_fname]>5 and random.choice([1,2])==1)
def subst_some_synth_for_synthcache(events):
    reverse_transTbl = {}
    for k,v in list(synthCache_transtbl.items()): reverse_transTbl[v]=k
    for i in range(len(events)):
        if hasattr(events[i][1],"file") and events[i][1].file.startswith(synthCache+os.sep):
            cache_fname = B(events[i][1].file[len(synthCache+os.sep):])
            cache_fname = reverse_transTbl.get(cache_fname,cache_fname)
            if cache_fname[:1]==B("_"): continue # a sporadically-used synthCache entry anyway
            if type(synthCache_test_mode)==type([]):
                found=0
                for str in synthCache_test_mode:
                    if (re and re.search(str,cache_fname)) or cache_fname.find(str)>=0:
                        found=1 ; break
                if found: continue
            lang = languageof(cache_fname)
            if get_synth_if_possible(lang) and decide_subst_synth(cache_fname): events[i] = (events[i][0],synth_event(lang,cache_fname[:cache_fname.rindex(B("_"))]))
emergency_lessonHold_to = 0
sequenceIDs_to_cancel = {} ; lessonStartTime = 0 ; wordsLeft={False:0,True:0}
def play(event):
    global copy_of_runner_events, lessonStartTime
    if 0: pass # trimmed
    else:
        while time.time() < emergency_lessonHold_to:
            if not app: doLabel("Emergency brief interrupt: %d" % (emergency_lessonHold_to-time.time()))
            time.sleep(1)
        t = "%d:%02d:%02d" % time.localtime()[3:6]
    timeout_time = time.time() + max(10,event.length/3)
    if lessonStartTime and not soundCollector:
        if hasattr(event,"max_lateness"): timeout_time = min(timeout_time, lessonStartTime + (copy_of_runner_events[0][2]+event.max_lateness))
        if hasattr(event,"sequenceID") and checkIn(event.sequenceID,sequenceIDs_to_cancel): timeout_time = 0
    play_error = "firstTime"
    while play_error and time.time()<=timeout_time:
        if not play_error=="firstTime":
            if not app: show_info("Problem playing sound - retrying\n")
            time.sleep(0.2)
        if not teacherMode or (event.makesSenseToLog() and getYN("NOW say "+maybe_unicode(str(event))+"\nComputer say it instead?")): play_error = event.play()
        else: play_error = 0
    if not play_error and logFile and event.makesSenseToLog(): logFileHandle.write(t+" "+str(event)+"\n")
    if play_error and hasattr(event,"wordToCancel") and event.wordToCancel:
        cancelledFiles.append(event.wordToCancel)
        if hasattr(event,"sequenceID"): sequenceIDs_to_cancel[event.sequenceID]=True # TODO what if its last event has "endseq" attribute, do we want to decrement wordsLeft early?
    if hasattr(event,"endseq"): wordsLeft[event.endseq] -= 1
    del copy_of_runner_events[0]
    if 0: pass # trimmed
    line2 = "" # report what you'd lose if you cancel now (in case you're deciding whether to answer the phone etc), + say how many already cancelled (for diagnosing results of interruptions caused by phone events etc on those platforms)
    new,old=wordsLeft[True],wordsLeft[False]
    if new: line2="%d new " % new
    if old:
      if line2: line2 += ("+ %d old " % old)
      else: line2="%d old words " % old
    elif new: line2 += "words "
    if line2:
      line2=cond(app or appuifw or android,"\n",", ")+line2+"remain"
      if cancelledFiles: line2 += "\n("+str(len(cancelledFiles))+" cancelled)"
    if not lessonStartTime: lessonStartTime = time.time()
    if finishTime and time.time() >= emergency_lessonHold_to: doLabel("%s (finish %s)%s" % (time.strftime("%H:%M",time.localtime(time.time())),time.strftime("%H:%M",time.localtime(finishTime)),line2))
def doLabel(labelText):
    labelText = ensure_unicode(labelText)
    if 0: pass # trimmed
    elif appuifw:
        t=appuifw.Text() ; t.add(labelText)
        appuifw.app.body = t
    elif not (riscos_sound or winCEsound):
        global doLabelLastLen
        try: doLabelLastLen
        except NameError: doLabelLastLen=0
        show_info("   "+labelText+(" "*(doLabelLastLen-len(labelText)))+"\r")
        doLabelLastLen=len(labelText)
        if msvcrt and msvcrt.kbhit() and msvcrt.getche()==" ": raise KeyboardInterrupt()
def initLogFile():
    global logFileHandle
    logFileHandle = None
    if logFile:
        try:
            logFileHandle = open(logFile,'w')
        except: pass
runner = None
teacherMode = 0
if ask_teacherMode:
  old_mysleep = mysleep
  def mysleep(secs):
    if not teacherMode: return old_mysleep(secs)
    t=time.time() ; label = 0 ; timeToIndicate = secs
    for e in copy_of_runner_events:
        if e[0].makesSenseToLog():
            timeToIndicate += e[2]-copy_of_runner_events[0][2]
            label = maybe_unicode(str(e[0]))
            if hasattr(e[0],"max_lateness"): label=", max +"+str(int(e[0].max_lateness))+": "+label
            else: label=": "+label
            break
    while time.time()<t+secs:
        if label: doLabel("In "+str(int(t+timeToIndicate-time.time()))+" secs"+label)
        old_mysleep(1)
def maybe_unicode(label):
    if app or appuifw or android:
        try: return unicode(label,'utf-8')
        except: return label
    else: return repr(label)
madplay_path = None
if (winsound or mingw32) and fileExists("madplay.exe"): madplay_path = "madplay.exe"
if madplay_path and not mp3Player: mp3Player=madplay_path
def intor0(v):
    try: return int(v)
    except ValueError: return 0
def digitPrefix(v):
    l = []
    for d in list(v):
        if '0' <= d <= '9': l.append(d)
        else: break
    return intor0(''.join(l))
sox_effect=""
sox_8bit, sox_16bit, sox_ignoreLen, sox_signed = "-b", "-w", "", "-s"
soundVolume_dB = math.log(soundVolume)*(-6/math.log(0.5))
if 0: pass # trimmed
else: gotSox = got_program("sox")
wavPlayer_override = not (not wavPlayer)
if 0: pass # trimmed
may_need_mp3_warning = ((wavPlayer or winsound or riscos_sound or mingw32) and not (mp3Player or gotSox))
def maybe_warn_mp3(): pass # trimmed
sox_same_endian = sox_little_endian = ""
if 0: pass # trimmed
def changeToDirOf(file,winsound_also=0):
    file = S(file)
    if winCEsound and not ' ' in file: return file # don't need to quote
    elif winsound_also and not (winsound or mingw32 or cygwin): return '"'+file+'"'
    return file
def system(cmd):
    if riscos_sound and type("")==type(u""): # work around memory issues with os.system() in RISC OS Python 3.8 (not needed if the command is a module rather than a program)
        import subprocess
        return subprocess.Popen(S(cmd).replace('"','').split()).wait()
    if not hasattr(os,"popen"): return os.system(cmd)
    if 0: pass # trimmed
    try: r=os.popen(cmd)
    except: return os.system(cmd)
    r.read() ; return r.close()
signal=0
if 0: pass # trimmed
def soundFileType(file):
    file,sep = B(file),B(extsep)
    if sep in file: return S(file[file.rindex(sep)+1:].lower())
    else: return "wav"
def lessonIsTight(): return maxLenOfLesson <= 10*60 * min(1.8,max(1,maxNewWords/5.0))
class SampleEvent(Event):
    def __init__(self,file,useExactLen=False,isTemp=False):
        if 0: pass # trimmed
        self.file = file
        self.exactLen = lengthOfSound(file)
        if isTemp: self.isTemp=1
        approxLen = self.exactLen
        if not lessonIsTight() and not useExactLen: approxLen = math.ceil(self.exactLen)
        Event.__init__(self,approxLen)
    def __repr__(self):
        if 0: pass # trimmed
        else: return S(self.file)
    def __del__(self):
      if hasattr(self,"isTemp"):
        import time,os
        while True:
          try: return os.unlink(self.file)
          except: time.sleep(0.2)
          if not fileExists_stat(self.file): break
    def makesSenseToLog(self):
        if hasattr(self,"is_prompt"): return not self.is_prompt
        return not B(self.file).startswith(B(promptsDirectory))
    def play(self):
        if 0: pass # trimmed
        fileType=soundFileType(self.file)
        if 0: pass # trimmed
        elif appuifw:
            fname = self.file
            if not B(fname[1:2])==B(":"): fname=B(os.getcwd()+cwd_addSep)+B(fname)
            sound = audio.Sound.open(ensure_unicode(fname))
            sound.play()
            try: time.sleep(self.length)
            finally: sound.stop()
            sound.close()
            return
        elif fileType=="mp3" and madplay_path and mp3Player==madplay_path and not macsound and not wavPlayer=="aplay":
            oldcwd = os.getcwd()
            play_error = system(mp3Player+' -q -A '+str(soundVolume_dB)+' "'+changeToDirOf(self.file)+'"') # using changeToDirOf because on Cygwin it might be a non-cygwin madplay.exe that someone's put in the PATH.  And keeping the full path to madplay.exe because the PATH may contain relative directories.
            os.chdir(oldcwd)
            return play_error
        elif fileType=="mp3" and mp3Player and not sox_effect and not (wavPlayer=="aplay" and mp3Player==madplay_path): return system(mp3Player+' "'+S(self.file)+'"')
        elif wavPlayer=="sox" and (soxMp3 or not fileType=="mp3"):
            t = time.time()
            play_error = system('cat "%s" | sox -t %s - %s %s%s >/dev/null' % (S(self.file),fileType,sox_type,oss_sound_device,sox_effect))
            if play_error: return play_error
            else:
                timeDiff = time.time()-t
                if timeDiff > self.exactLen/2.0: return 0
                if timeDiff==0 and self.exactLen < 1.5: return 0
                if not app: show_info("play didn't take long enough - maybe ") # .. problem playing sound
                return 1
        elif fileType=="mp3" and mp3Player and not sox_effect: return system(mp3Player+' "'+S(self.file)+'"')
        elif fileType=="mp3" and mp3Player: return system(mp3Player+' "'+S(self.file)+'"') # ignore sox_effect
        else: show_warning("Don't know how to play \""+self.file+'" on this system')
br_tab=[(0 , 0 , 0 , 0 , 0),
(32 , 32 , 32 , 32 , 8),
(64 , 48 , 40 , 48 , 16),
(96 , 56 , 48 , 56 , 24),
(128 , 64 , 56 , 64 , 32),
(160 , 80 , 64 , 80 , 40),
(192 , 96 , 80 , 96 , 48),
(224 , 112 , 96 , 112 , 56),
(256 , 128 , 112 , 128 , 64),
(288 , 160 , 128 , 144 , 80),
(320 , 192 , 160 , 160 , 96),
(352 , 224 , 192 , 176 , 112),
(384 , 256 , 224 , 192 , 128),
(416 , 320 , 256 , 224 , 144),
(448 , 384 , 320 , 256 , 160),
(0 , 0 , 0 , 0 , 0)]
def rough_guess_mp3_length(fname):
  try:
    maybe_warn_mp3()
    o = open(fname,"rb") ; i = -1
    while True:
      head=o.read(512)
      if len(head)==0: raise IndexError
      i=head.find(LB('\xFF'))
      if i==-1: continue
      if i+2 < len(head): head += o.read(3)
      o.seek(o.tell()-len(head)+i+2) ; b=ord(head[i+1:i+2])
      if b >= 0xE0: break
    s = o.tell() ; o.close()
    layer = 4-((b&6)>>1)
    if b&24 == 24:
      column = layer-1
    elif layer==1: column = 3
    else: column = 4
    bitrate = br_tab[ord(head[i+2:i+3])>>4][column]
    if bitrate==0: bitrate=48
    return (filelen(fname)-s)*8.0/(bitrate*1000)
  except IndexError: raise Exception("Invalid MP3 header in file "+repr(fname))
def filelen(fname):
    try: fileLen=os.stat(fname).st_size
    except: fileLen=len(read(fname))
    return fileLen
def lengthOfSound(file):
    if B(file).lower().endswith(B(dotmp3)): return rough_guess_mp3_length(file)
    else: return pcmlen(file)
if type("")==type(u""):
    import wave
    def swhat(file):
        if file.lower().endswith(os.extsep+"wav"):
            o = wave.open(file,'rb')
            return "wav",o.getframerate(),o.getnchannels(),o.getnframes(),8*o.getsampwidth()
        else:
            import sndhdr
            return sndhdr.what(file)
else:
    import sndhdr
    swhat = sndhdr.what
def pcmlen(file):
    header = swhat(file)
    (wtype,wrate,wchannels,wframes,wbits) = header
    if 0: pass # trimmed
    divisor = wrate*wchannels*int(wbits/8)
    if not divisor: raise IOError("Cannot parse sample format of '%s': %s" % (file,repr(header)))
    return (filelen(file) - 44.0) / divisor
class SoundCollector(object): pass # trimmed
def outfile_writeBytes(*_): pass # trimmed
def outfile_close(o): pass # trimmed
def outfile_writeFile(*_): pass # trimmed
def outfile_write_error(): pass # trimmed
def oggenc(): pass # trimmed
def lame_endian_parameters(): pass # trimmed
def lame_quiet(): pass # trimmed
betweenBeeps = 5.0
beepType = 0
beepCmds = ["sox -t nul - %s %s synth trapetz 880 trim 0 0:0.05",
"sox -t nul - %s %s synth sine 440 trim 0 0:0.05"]*3+["sox -t nul - %s %s synth trapetz 440 trim 0 0:0.05",
"sox -t nul - %s %s synth sine 440 trim 0 0:0.05"]*2+["sox -t nul - %s %s synth 220 trim 0 0:0.05"]
def beepCmd(*_): pass # trimmed
class ShSoundCollector(object): pass # trimmed
def dd_command(*_): pass # trimmed
warned_about_sox_decode = 0
def warn_sox_decode(): pass # trimmed
def decode_mp3(*_): pass # trimmed
class Mp3FileCache(object): pass # trimmed
theMp3FileCache = Mp3FileCache()
soundCollector = None
try:
    outputFile = bigOutputFile
    outputFile_appendSilence = bigOutputFile_appendSilence
except NameError: pass
sample_table_hack = 0
if 0: pass # trimmed
if not (soundCollector and out_type=="sh"): compress_SH = False
def collector_time(): pass # trimmed
def collector_sleep(s): pass # trimmed
def quickGuess(letters,lettersPerSec): return math.ceil(letters*1.0/lettersPerSec)
class Synth(object):
    def supports_language(self,lang): return 0
    def not_so_good_at(self,lang): return 0
    def works_on_this_platform(self): return 0
    def __init__(self): self.fileCache = {}
    def __del__(self):
        try: import os
        except: pass
        try:
          for v in self.fileCache.values():
            try: os.remove(v)
            except: pass
        except: pass
        self.fileCache = {}
    def makefile_cached(self,lang,text):
        if type(text)==type([]): textKey=repr(text)
        else: textKey=text
        if checkIn((lang,textKey),self.fileCache): return self.fileCache[(lang,textKey)]
        t = self.makefile(lang,text)
        self.fileCache[(lang,textKey)] = t
        return t
    def finish_makefile(self): pass
    def transliterate(self,lang,text,forPartials=1): return None
    def can_transliterate(self,lang): return 0
try:
    import warnings
    warnings.filterwarnings("ignore","tempnam is a potential security risk to your program")
except ImportError: pass
def unzip_and_delete(f,specificFiles="",ignore_fail=0):
    if ignore_fail:
        if not got_program("unzip"):
            show_warning("Please unzip "+f+" (Gradint cannot unzip it for you as there's no 'unzip' program on this system)")
            return 1
    show_info("Attempting to extract %s, please wait\n" % (f,))
    if os.system("unzip -uo "+f+" "+specificFiles) and not ignore_fail:
        show_warning("Warning: Failed to unzip "+f)
        return 0
    else:
        os.remove(f)
        show_info(f+" unpacked successfully\n")
        return 1
class OSXSynth_Say(Synth): pass # trimmed
def aiff2wav(*_): pass # trimmed
class OSXSynth_OSAScript(Synth): pass # trimmed
class OldRiscosSynth(Synth): pass # trimmed
class S60Synth(Synth):
    def __init__(self): Synth.__init__(self)
    def supports_language(self,lang): return lang=="en" # (audio.say always uses English even when other languages are installed on the device)
    def works_on_this_platform(self): return appuifw and hasattr(audio,"say")
    def guess_length(self,lang,text): return quickGuess(len(text),12)
    def play(self,lang,text):
        if not text=="Error in graddint program.": # (just in case it's unclear)
          if text.endswith(';'): doLabel(text[:-1])
          else: doLabel(text)
        audio.say(text)
class AndroidSynth(Synth): pass # trimmed
if 0: pass # trimmed
else: toNull=" >/dev/null"
def ensure_unicode(text):
    if type(text)==type(u""): return text
    else:
        try: return unicode(text,"utf-8")
        except UnicodeDecodeError: raise Exception("problem decoding "+repr(text))
class PttsSynth(Synth): pass # trimmed
def sapi_sox_bug_workaround(*_): pass # trimmed
py_final_letters="aeginouvrAEGINOUVR:"
def sort_out_pinyin_3rd_tones(pinyin):
    segments = [] ; thisSeg = B("") ; syls = 0 ; pinyin=B(pinyin)
    def endsWithSpecialWordpair(segLower): return segLower.endswith(B("gei3 ni3")) or segLower.endswith(B("gei3 wo3")) or segLower.endswith(B("ni3 xiang3")) or segLower.endswith(B("wo3 xiang3"))
    for i in xrange(len(pinyin)):
        c = pinyin[i:i+1]
        if ord(c)>128 or c in B(".,?;") or (c==B(" ") and syls==2) or endsWithSpecialWordpair(thisSeg.lower()):
            segments.append(thisSeg) ; thisSeg=B("") ; syls = 0
        elif c==B(" "): syls = 0
        elif c in B("12345"): syls += 1
        thisSeg += c
    segments.append(thisSeg)
    ret = []
    for seg in segments:
      i=0
      while i<len(seg):
        while i<len(seg) and seg[i:i+1] not in B('12345'): i+=1
        if i<len(seg) and seg[i:i+1]==B('3') and i and seg[i-1:i] in B(py_final_letters):
            toneToChange = i ; numThirdsAfter = 0
            j = i
            while True:
                j += 1
                while j<len(seg) and seg[j:j+1] not in B('12345'): j+=1
                if j<len(seg) and seg[j:j+1]==B('3') and seg[j-1:j] in B(py_final_letters): numThirdsAfter+=1
                else: break
            if numThirdsAfter % 2: seg=seg[:toneToChange]+B('2')+seg[toneToChange+1:]
        i += 1
      ret.append(seg)
    return B("").join(ret)
class FliteSynth(Synth): pass # trimmed
if 0: pass # trimmed
if 0: pass # trimmed
espeak_language_aliases = { "cant":"zhy" }
class SimpleZhTransliterator(object):
    def can_transliterate(self,lang): return lang=="zh"
    def transliterate(self,lang,text,forPartials=1,for_espeak=0):
        text = B(text)
        if not lang=="zh": return text
        if text.find(B("</")) > -1: return text
        text = preprocess_chinese_numbers(fix_compatibility(ensure_unicode(text))).replace(u'\u0144g','ng2').replace(u'\u0148g','ng3').replace(u'\u01f9g','ng4').encode("utf-8") # (ng2/3/4 substitution here because not all versions of eSpeak can do it)
        found=0
        for i in xrange(len(text)):
            if ord(text[i:i+1])>=128:
                found=1 ; break
        if not found and text.lower()==fix_pinyin(text,[]): return text
        elif for_espeak:
            for s,r in [('\xc4\x80', '\xc4\x81'), ('\xc3\x81', '\xc3\xa1'), ('\xc7\x8d', '\xc7\x8e'), ('\xc3\x80', '\xc3\xa0'), ('\xc4\x92', '\xc4\x93'), ('\xc3\x89', '\xc3\xa9'), ('\xc4\x9a', '\xc4\x9b'), ('\xc3\x88', '\xc3\xa8'), ('\xc5\x8c', '\xc5\x8d'), ('\xc3\x93', '\xc3\xb3'), ('\xc7\x91', '\xc7\x92'), ('\xc3\x92', '\xc3\xb2')]: text = text.replace(LB(s),LB(r))
            return [text]
        elif not found: return fix_pinyin(text,[])
simpleZhTransliterator = SimpleZhTransliterator()
def shell_escape(text):
    text = B(text).replace(B('\\'),B('\\\\')).replace(B('"'),B('\\"'))
    if 0: pass # trimmed
    return B('"')+text+B('"')
espeakTranslitCacheFile = "espeak-translit-cache"+extsep+"bin"
class ESpeakSynth(Synth): pass # trimmed
def fix_commas(text):
  i=0 ; text=B(text)
  while i<len(text)-1:
    if text[i:i+1] in B('.,?;!'):
      tRest = bwspstrip(text[i+1:])
      if tRest and (ord(tRest[:1])>=128 or B('a')<=tRest[:1].lower()<=B('z')):
        text=text[:i+1]+cond(text[i:i+1] in B(".?!"),B("  ")+tRest[:1].upper(),B(" ")+tRest[:1])+tRest[1:]
    i+=1
  return text
def fix_pinyin(pinyin,en_words):
  if en_words:
    ret=[]
    def stripPunc(w):
      w=B(w) ; i=0 ; j=len(w) ; w=w.lower()
      while i<len(w) and not B('a')<=w[i:i+1]<=B('z'): i+=1
      while j>1 and not (B('a')<=w[j-1:j]<=B('z') or B('1')<w[j-1:j]<=B('5')): j-=1
      return w[i:j]
    for w in pinyin.split():
      if checkIn(stripPunc(w),en_words): ret.append(w)
      else: ret.append(fix_pinyin(w,[]))
    return B(' ').join(ret)
  i=0
  pinyin=pinyin_uColon_to_V(pinyin)+B("@@@") # (includes .lower; @@@ for termination)
  while i<len(pinyin):
    if pinyin[i:i+1] in B("12345"):
      moveBy=0
      if pinyin[i+1:i+2] in B("iuv"): moveBy=1
      elif pinyin[i+1:i+2]==B("o") and not pinyin[i+2:i+3] in B("u12345"): moveBy=1 # "o" and "ou" are valid syllables, but a number before "o" is likely to be premature especially if the "o" is not itself followed by a number (or "u")
      elif pinyin[i+1:i+3]==B("ng") and not pinyin[i+3:i+4] in B("aeiouv"): moveBy=2
      elif pinyin[i+1:i+2] in B("nr") and not pinyin[i+2:i+3] in B("aeiouv") and not (pinyin[i+1:i+2]==B("r") and i and not pinyin[i-1:i]==B("e")) and not pinyin[i+1:i+3]==B("r5"): moveBy=1
      if moveBy: pinyin=pinyin[:i]+pinyin[i+1:i+moveBy+1]+pinyin[i:i+1]+pinyin[i+moveBy+1:]
    i+=1
  i=0
  while i<len(pinyin):
    if (pinyin[i:i+1] in B("aeiouvr") and pinyin[i+1:i+2] not in B("aeiouv12345")) or (ord('a')<=ord(pinyin[i:i+1])<=ord('z') and not (ord("a")<=ord(pinyin[i+1:i+2])<=ord("z") or pinyin[i+1:i+2] in B("12345"))): # ("alnum and next is not alnum" is not strictly necessary, but we do need to add 5's after en-like words due to 'fix_pinyin(t)==t' being used as a do-we-need-proper-translit. condition in SimpleZhTransliterator, otherwise get problems with things like "c diao4" going to eSpeak when it could go to partials-with-letter-substitutions)
      if pinyin[i+1:i+3]==B("ng") and not pinyin[i+3:i+4] in B("aeiouv"):
        if pinyin[i+3:i+4] not in B("12345"): pinyin=pinyin[:i+3]+B("5")+pinyin[i+3:]
      elif (pinyin[i+1:i+2]==B("n") or pinyin[i:i+2]==B("er")) and not pinyin[i+2:i+3] in B("aeiouv") and not pinyin[i:i+1]==B("r"):
        if pinyin[i+2:i+3] not in B("12345"): pinyin=pinyin[:i+2]+B("5")+pinyin[i+2:]
      else: pinyin=pinyin[:i+1]+B("5")+pinyin[i+1:]
    i+=1
  return pinyin[:-3]
def remove_tone_numbers(utext):
    i=1
    while i<len(utext):
        if "1"<=utext[i]<="5" and "a"<=utext[i-1].lower()<="z" and (i==len(utext)-1 or not "0"<=utext[i+1]<="9"): utext=utext[:i]+utext[i+1:]
        i+=1
    return utext
def preprocess_chinese_numbers(utext,isCant=0):
    for year in ["nian2",u"\u5e74"]: # TODO also " nian2" to catch that? what of multiple spaces?
        while utext.find(year)>=4 and 1200 < intor0(utext[utext.index(year)-4:utext.index(year)]) < 2300:
            yrStart = utext.index(year)-4
            utext = utext[:yrStart] + " ".join(list(utext[yrStart:yrStart+4]))+" "+utext[yrStart+4:]
    i=0
    while i<len(utext):
        if "0"<=utext[i]<="9" and not ("1"<=utext[i]<=cond(isCant,"7","5") and i and "a"<=utext[i-1].lower()<="z" and (i==len(utext)-1 or not "0"<=utext[i+1]<="9")): # number that isn't a tone digit
            j=i
            while j<len(utext) and utext[j] in "0123456789.": j += 1
            while utext[j-1]==".": j -= 1 # exclude trailing point(s)
            num = read_chinese_number(utext[i:j])
            if isCant:
              for mand,cant in zip("ling2 yi1 er4 san1 si4 wu3 liu4 qi1 ba1 jiu3 dian3 yi4 qian1 bai3 shi2 wan4".split(),cond(isCant==2,u"\u96f6 \u4e00 \u4e8c \u4e09 \u56db \u4e94 \u516d \u4e03 \u516b \u4e5d \u70b9 \u4ebf \u5343 \u767e \u5341 \u4e07","ling4 jat1 ji6 saam7 sei3 ng5 luk6 cat7 baat3 gau2 dim2 jik1 cin7 baak3 sap6 maan6").split()): num=num.replace(mand,cant)
            utext=utext[:i]+num+utext[j:]
            i += len(num)
        else: i += 1
    return utext
def read_chinese_number(num):
    digits="ling2 yi1 er4 san1 si4 wu3 liu4 qi1 ba1 jiu3".split()
    nums=num.split(".")
    if len(nums)==1:
        columns=("yi4 qian1 bai3 shi2 wan4 qian1 bai3 shi2".split()+[""])
        has_wan = not ("00000000"+num)[-8:-4]=="0000"
        if len(num)>len(columns) or (num and num[0]=="0"): return "".join([digits[ord(d)-ord("0")] for d in num])
        r=[]
        for d,c,i in zip(list(num),columns[-len(num):],range(len(num))):
            if d=="0":
                if c=="wan4" and has_wan: r.append(c)
                elif c and not (r and r[-1]=="ling2"): r.append("ling2")
            elif d=="1" and c=="shi2" and (i==0 or (r and r[-1]=="ling2")): r.append(c)
            else: r.append(digits[ord(d)-ord("0")]+c)
        if len(r)>1 and r[-1]=="ling2": del r[-1]
        return "".join(r)
    elif len(nums)==2:
        rVal = [read_chinese_number(nums[0]),"dian3"]
        for d in nums[1]: rVal.append(digits[ord(d)-ord("0")])
        return "".join(rVal)
    else: return "dian3".join([read_chinese_number(n) for n in nums])
def fix_compatibility(utext):
    r = []
    for c in utext:
        if 0xff01<=ord(c)<=0xff5e: r.append(unichr(ord(c)-0xfee0))
        elif 0x2010 <= ord(c) <= 0x2015: r.append("-")
        elif c==unichr(0x201a): r.append(",") # sometimes used as comma (incorrectly)
        elif 0x2018 <= ord(c) <= 0x201f or 0x3008 <= ord(c) <= 0x301b: r.append('"')
        elif c==unichr(0xff61): r.append(".")
        else: r.append(c)
    return u"".join(r)
espeak_pipe_through = "" # or "--stdout|..." (NOT on Windows)
def espeak_stdout_works(): pass # trimmed
def espeak_volume_ok(): pass # trimmed
if wavPlayer_override or (unix and not macsound and not (oss_sound_device=="/dev/sound/dsp" or oss_sound_device=="/dev/dsp")):
    if wavPlayer=="aplay" and espeak_stdout_works(): espeak_pipe_through="--stdout|aplay -q" # e.g. NSLU2
    else: del ESpeakSynth.play
    if hasattr(FliteSynth,"play"): del FliteSynth.play
if hasattr(ESpeakSynth,"play") and (soundVolume<0.04 or (soundVolume<0.1 and not espeak_volume_ok()) or soundVolume>2): del ESpeakSynth.play
globalEspeakSynth = ESpeakSynth()
class ESpeakSynth(ESpeakSynth):
    def __init__(self): self.__dict__ = globalEspeakSynth.__dict__
class EkhoSynth(Synth): pass # trimmed
class FestivalSynth(Synth): pass # trimmed
class ChatterboxSynth(Synth):
    def __init__(self):
        Synth.__init__(self) ; self.model = None
    def works_on_this_platform(self):
        try:
            import importlib
            return importlib.util.find_spec('chatterbox')
        except: return 0
    def supports_language(self,lang): return lang=="en"
    def guess_length(self,lang,text): return quickGuess(len(text),12)
    def makefile(self,lang,text):
        if not self.model:
            import torch;from chatterbox.tts import ChatterboxTTS
            self.model = ChatterboxTTS.from_pretrained(device=cond(torch.cuda.is_available(),"cuda","cpu")) # cuda can run out of GPU RAM if reading long texts; may need cpu (slower) for that.  But cuda is probably OK for the short words / phrases Gradint is likely to use, and anyway cpu + long texts can result in some sections of the text missing.
        text = ensure_unicode(text)
        fname = os.tempnam()+dotwav
        import torchaudio
        torchaudio.save(fname,self.model.generate(text),self.model.sr)
        return fname
class CoquiSynth(Synth): pass # trimmed
class PiperSynth(Synth): pass # trimmed
class GeminiSynth(Synth):
    def __init__(self):
        Synth.__init__(self)
        self.lCache = {}
    def works_on_this_platform(self):
        if os.environ.get("GEMINI_API_KEY"):
            try:
                global genai, wave
                from google import genai
                import wave
                return True
            except: pass
    def supports_language(self,lang): return True
    def guess_length(self,lang,text): return quickGuess(len(text),cond(lang in ["zh"],6,12))
    def makefile(self,lang,text):
        for Try in [2,1,0]:
            try: frames=genai.Client().models.generate_content(model="gemini-2.5-flash-preview-tts",contents=ensure_unicode(text),config=genai.types.GenerateContentConfig(response_modalities=["AUDIO"],speech_config=genai.types.SpeechConfig(voice_config=genai.types.VoiceConfig(prebuilt_voice_config=genai.types.PrebuiltVoiceConfig(voice_name=random.choice(os.environ.get('GEMINI_VOICES','Aoede,Kore,Laomedeia,Sulafat').split(','))))))).candidates[0].content.parts[0].inline_data.data
            except:
                if Try:
                    sys.stderr.write("Gemini fetch error: waiting 1 minute before retry\n"), time.sleep(60)
                    continue
                raise
            break
        fname = os.tempnam()+dotwav
        w=wave.open(fname,'wb')
        w.setnchannels(1),w.setsampwidth(2),w.setframerate(24000)
        w.writeframes(frames)
        w.close() ; return fname
class GeneralSynth(Synth): pass # trimmed
class GeneralFileSynth(Synth): pass # trimmed
all_synth_classes = [GeneralSynth,GeneralFileSynth]
all_synth_classes += [GeminiSynth,CoquiSynth,PiperSynth,ChatterboxSynth]
for s in synth_priorities.split(): pass # trimmed
all_synth_classes += [FestivalSynth,FliteSynth,OldRiscosSynth,S60Synth,AndroidSynth]
prefer_espeak = prefer_espeak.split()
viable_synths = []
warned_about_nosynth = {}
getsynth_cache = {}
def setSoundCollector(sc): pass # trimmed
def get_synth_if_possible(language,warn=1,to_transliterate=False):
    language = S(language)
    if checkIn(language,getsynth_cache) and not to_transliterate: return getsynth_cache[language]
    if language==None:
        if not checkIn(None,getsynth_cache): getsynth_cache[None]=Partials_Synth()
        return getsynth_cache[None]
    global viable_synths, warned_about_nosynth
    if not viable_synths:
        for C in all_synth_classes:
            instance = C()
            if instance.works_on_this_platform() and (not soundCollector or hasattr(instance,"makefile")): viable_synths.append(instance)
    if to_transliterate:
        for synth in viable_synths:
            if synth.supports_language(language) and synth.can_transliterate(language): return synth
        if language=="zh": return simpleZhTransliterator
    for synth in viable_synths:
        if synth.supports_language(language) and not synth.not_so_good_at(language):
            getsynth_cache[language]=synth ; return synth
    for synth in viable_synths:
        if synth.supports_language(language):
            if warn and language not in synth_partials_voices and not language==firstLanguage and language in ["zh","cant","zhy","zh-yue"] and not language in warned_about_nosynth:
                warned_about_nosynth[language] = 1
                show_warning("You don't have "+cond(language=="zh","Yali Cheng's Mandarin","Cameron Wong's Cantonese")+" voice installed, only a more basic robot voice. Please see the sidebar on the Gradint website for downloads.")
                if 0: pass # trimmed
                getsynth_cache[language]=synth
            return synth
    if (not warn) or language not in [firstLanguage,secondLanguage]+possible_otherLanguages: return None
    if not checkIn(language,warned_about_nosynth):
        warned_about_nosynth[language] = 1
        canSay = []
        if checkIn(language,synth_partials_voices): canSay.append("recorded syllables (partials)")
        if synthCache: canSay.append("recorded phrases (synthCache)")
        if canSay: canSay="\n  - can use only "+" and ".join(canSay)
        else: canSay="\n  (did you read ALL the comments in vocab.txt?)"
        show_warning(("Warning: No speech synthesizer installed for language '%s'"+cond(appuifw or winCEsound,"",canSay)) % (language,))
    return None
def synth_event(language,text,is_prompt=0):
    synth = get_synth_if_possible(language) ; assert synth, "Cannot get synth for '%s'" % (language,)
    return SynthEvent(text,synth,language,is_prompt)
def pinyin_uColon_to_V(pinyin):
    pinyin = pinyin.lower()
    pristineU = unichr(0xfc).encode('utf-8')
    pinyin = B(pinyin).replace(B("j")+pristineU,B("ju")).replace(B("q")+pristineU,B("qu")).replace(B("x")+pristineU,B("xu")).replace(pristineU,B("v")).replace(unichr(0xea).encode('utf-8'),B("e")) # for pristine's pinyin
    return pinyin.replace(B("u:"),B("v")).replace(B("leu"),B("lv")).replace(B("neu"),B("nv"))
class SynthEvent(Event):
    def __init__(self,text,synthesizer,language,is_prompt=0):
        assert text,"Trying to speak zero-length text"
        self.text = B(text) ; self.synthesizer = synthesizer
        self.modifiedText = self.text
        if language=="en":
            self.modifiedText = self.modifiedText.replace(LB("\xE2\x80\xA7"),B("")).replace(LB("\xE2\x80\xB2"),B("")) # remove syllable boundaries and primes (usually just confuse speech synths)
            if not self.text[-1:] in B(";.!?-") and not (B(';') in self.text and B(';') in self.text[self.text.index(B(';'))+1:]): self.modifiedText += B(';') # prosody hack (some synths sound a bit too much like 'disjointed strict commands' without this)
        elif language=="zh":
            self.modifiedText = pinyin_uColon_to_V(self.modifiedText)
            for t in ["1","2","3","4","5"]: self.modifiedText = self.modifiedText.replace(B(t+"-"),B(t+" ")) # for Lily, Lisheng etc.  NB replace hyphen with space not with "", otherwise can get problems with phrases like "wang4en1-fu4yi4".  DON'T do it except after tone marks, because for hanzi we might want to use hyphens for word-boundary disambiguation.
            if (not B(" ") in self.modifiedText) and (B("1") in self.modifiedText or B("2") in self.modifiedText or B("3") in self.modifiedText or B("4") in self.modifiedText or B("5") in self.modifiedText):
                self.modifiedText=fix_pinyin(self.modifiedText,[])
                for f in py_final_letters:
                    for t in "12345": self.modifiedText=self.modifiedText.replace(B(f+t),B(f+t+" "))
            if synthesizer.__class__ in [GeneralSynth, GeneralFileSynth]:
                self.modifiedText=fix_commas(fix_compatibility(ensure_unicode(self.modifiedText)).encode('utf-8'))
            elif synthesizer.__class__ in [PttsSynth]: self.modifiedText = sort_out_pinyin_3rd_tones(self.modifiedText)
        self.language = language
        self.is_prompt = is_prompt ; self.sound = None
        if soundCollector and lessonIsTight():
            self.sound = synthesizer.makefile_cached(language,self.modifiedText) ; synthesizer.finish_makefile()
            length = SampleEvent(self.sound).length
        else: length = synthesizer.guess_length(language,self.modifiedText)
        Event.__init__(self,length)
    def __repr__(self):
        if not self.language: return eventList_repr(self.text)
        return str(self.text)
    def __setstate__(self,state):
        synth = get_synth_if_possible(state['language'])
        assert synth, "Error: Trying to play a previously-stored lesson under conditions that prevent one of the speech synths from working as before (maybe trying to use an online-only synth offline?)"
        self.__init__(state['text'],synth,state['language'],state['is_prompt'])
    def __getstate__(self): return {"text":self.text,"language":self.language,"is_prompt":self.is_prompt}
    def makesSenseToLog(self): return not self.is_prompt
    def will_be_played(self):
        if not soundCollector and not hasattr(self.synthesizer,"play"):
            self.sound = self.synthesizer.makefile_cached(self.language,self.modifiedText)
        else: self.sound = None
    def getSound(self):
        if not self.sound: self.sound = self.synthesizer.makefile_cached(self.language,self.modifiedText)
        return self.sound
    def play(self):
        if soundCollector and not self.sound:
            self.sound = self.synthesizer.makefile_cached(self.language,self.modifiedText)
            self.synthesizer.finish_makefile()
        if sample_table_hack:
            if not checkIn(self.sound,sample_table_hack_lengthDic): sample_table_hack_lengthDic[self.sound]=SampleEvent(self.sound).exactLen
            soundCollector.addFile(self.sound,sample_table_hack_lengthDic[self.sound])
            open(self.sound,"wb") # i.e. truncate at 0 bytes to save space (but keep around so no name clashes)
        elif self.sound:
            for t in range(10):
                try: e = SampleEvent(self.sound)
                except IOError:
                    time.sleep(1) ; continue
                return e.play()
            raise IOError("IOError after 10 tries on "+repr(self.sound))
        else:
            assert (not soundCollector) and hasattr(self.synthesizer,"play"),"Should have called will_be_played before playing offline"
            return self.synthesizer.play(self.language,self.modifiedText)
sample_table_hack_lengthDic = {}
class ShellEvent(Event): pass # trimmed
def eventList_repr(el):
    r=[]
    def fname(p):
        if os.sep in p: p=p[p.rindex(os.sep)+1:]
        if extsep in p: p=p[:p.rindex(extsep)]
        return p
    for e in el:
        if type(e)==type([]) or hasattr(e,"eventList"):
            if not type(e)==type([]): e=e.eventList
            for ee in e:
                if not ee.__class__==Event: r.append(fname(str(ee)))
            r.append(",")
        elif not e.__class__==Event: r.append(fname(str(e)))
    return " ".join(r)
def abspath_from_start(p):
    d=os.getcwd()
    os.chdir(starting_directory)
    try: r=os.path.abspath(p)
    except: r="" # library problems on Windows?
    os.chdir(d)
    return r
def just_synthesize(callGeneralCheck=0,lastLang_override=None):
    global startAnnouncement,endAnnouncement,logFile,synth_partials_cache
    synth_partials_cache = {}
    oldStart,oldEnd,oldLogfile = startAnnouncement,endAnnouncement,logFile
    startAnnouncement=endAnnouncement=logFile=None
    if 0: pass # trimmed
    called_synth = 0
    global repeatMode ; repeatMode = 1
    while repeatMode and not repeatMode=="interrupted":
      repeatMode = 0
      less = Lesson()
      lastStartTime = lastEndTime = lastWasDelay = 0
      if lastLang_override: lastLanguage = lastLang_override
      else: lastLanguage = secondLanguage
      def checkCanSynth(fname):
          ret=can_be_synthesized(fname)
          if ret: return fileToEvent(fname)
          else: show_warning("Can't say "+repr(fname))
      for line in B(justSynthesize).split(B('#')):
        line = bwspstrip(line)
        l = line.split(None,1)
        if B(extsep) in line and fileExists(line): event = fileToEvent(line,"")
        elif B(extsep) in line and fileExists(abspath_from_start(line)): event = fileToEvent(abspath_from_start(line),"")
        elif line==B('R'):
            repeatMode=1 ; continue
        elif len(l)==1:
            try: delayVal = float(l[0])
            except ValueError: delayVal = None
            if delayVal==None:
                r = repr(l[0])
                if r[:1]=="b": r=r[1:]
                show_warning("Assuming that %s is a word to synthesize in language '%s'" % (r,lastLanguage))
                if callGeneralCheck and generalCheck(l[0],lastLanguage,1): return
                event = checkCanSynth("!synth:"+S(l[0])+"_"+S(lastLanguage))
                if not event: continue
                called_synth = 1
            else:
                lastWasDelay = 1
                if delayVal<0: lastEndTime = lastStartTime-delayVal
                else: lastEndTime += delayVal
                continue
        elif len(l)==2:
            lang, text = l
            if lang=="sh:": event = ShellEvent(text)
            else:
                fname = B("!synth:")+B(text)+B("_")+B(lang)
                if not can_be_synthesized(fname):
                    if lang in [firstLanguage,secondLanguage]+otherLanguages:
                        show_warning("Can't say %s in %s" % (repr(text),repr(lang)))
                        lastLanguage=lang ; continue
                    show_warning("Assuming %s was meant to be synthesized in language '%s'" % (cond(B('#') in B(justSynthesize) or len(repr(line))<10,"that '"+repr(line)+"'","this line"),lastLanguage))
                    if callGeneralCheck and generalCheck(line,lastLanguage,1): return
                    event = checkCanSynth("!synth:"+S(line)+"_"+S(lastLanguage))
                else:
                    if callGeneralCheck and generalCheck(text,lang,1): return
                    event = checkCanSynth(fname)
                    lastLanguage = lang
                if not event: continue
                called_synth = 1
        else: continue
        event.addToEvents(less.events,lastEndTime)
        lastWasDelay = 0
        lastStartTime = lastEndTime
        lastEndTime += event.length
      if lastWasDelay: Event(0).addToEvents(less.events,lastEndTime)
      global dbase ; dbase = None
      less.play()
    startAnnouncement,endAnnouncement,logFile = oldStart,oldEnd,oldLogfile
    if repeatMode=="interrupted": sys.exit(1)
    if not called_synth: return None
    return lastLanguage
def filesToEvents(files,dirBase=None):
    if not type(files)==type([]): files = [files]
    return CompositeEvent(map(lambda x,d=dirBase:fileToEvent(x,d),files))
class Partials_Synth(Synth):
    def guess_length(self,lang,text):
        l=(len(text)-1)*0.3
        for phrase in text: l+=quickGuess(len(phrase),1.5)
        return l
    def play(self,lang,text):
        if len(text)<=2 or self.guess_length(lang,text)<=10: return SampleEvent(self.makefile(lang,text),isTemp=1).play()
        t=0
        for phrase in text:
            e=SampleEvent(self.makefile(lang,[phrase]),isTemp=1)
            time.sleep(max(0,betweenPhrasePause-(time.time()-t)))
            e.play()
            t=time.time()
    def makefile(self,lang,text):
        fname = os.tempnam()+dotwav
        o=open(fname,"wb")
        if not (text and text[0] and B(text[0][0]).endswith(B(dotwav))): o.write(read(partialsDirectory+os.sep+"header"+dotwav))
        for phrase in text:
            datFileInUse = 0 ; assert type(phrase)==type([])
            for f in phrase:
                f = S(f)
                if checkIn(f,audioDataPartials):
                    datFile,offset,size = audioDataPartials[f]
                    if not datFileInUse: datFileInUse = open(partialsDirectory+os.sep+datFile,"rb")
                    datFileInUse.seek(offset) ; o.write(datFileInUse.read(size))
                else: o.write(read(partialsDirectory+os.sep+f))
            if not phrase==text[-1]: o.write(chr(0)*partials_raw_0bytes)
        wavLen = o.tell()-8
        o.seek(4) ; o.write(chr(wavLen&0xFF)+chr((wavLen>>8)&0xFF)+chr((wavLen>>16)&0xFF)+chr(wavLen>>24))
        wavLen -= 36 ; o.seek(40) ; o.write(chr(wavLen&0xFF)+chr((wavLen>>8)&0xFF)+chr((wavLen>>16)&0xFF)+chr(wavLen>>24))
        return fname
def fileToEvent(fname,dirBase=None):
    if dirBase==None: dirBase=samplesDirectory
    dirBase,fname = B(dirBase),B(fname)
    if dirBase: dirBase += B(os.sep)
    orig_DB,orig_fname = dirBase,fname
    if B(os.sep) in fname and fname.find(B("!synth:"))==-1: dirBase,fname = dirBase+fname[:fname.rindex(B(os.sep))+1], fname[fname.rindex(B(os.sep))+1:]
    if B("_") in fname: lang = languageof(fname)
    else: lang="-unknown-" # so can take a simple wav file, e.g. for endAnnouncement
    if checkIn(dirBase+fname,variantFiles):
        variantFiles[dirBase+fname]=variantFiles[dirBase+fname][1:]+[variantFiles[dirBase+fname][0]]
        fname=B(variantFiles[dirBase+fname][0])
    if fname.lower().endswith(B(dottxt)) and B("_") in fname:
        ftxt = bwspstrip(u8strip(read(dirBase+fname)))
        if not ftxt: raise MessageException(B("File ")+fname+B(" in ")+dirBase+B(" has no text in it; please fix this")) # nicer message than catching it at a lower level
        fname = B("!synth:")+B(ftxt)+B('_')+B(lang)
    if fname.find(B("!synth:"))>=0:
        s = synthcache_lookup(fname)
        if type(s)==type([]):
            if filter(lambda x:not type(x)==type([]), s):
                eList = []
                for phrase in s:
                    if type(phrase)==type([]):
                      if partials_raw_mode: eList.append(synth_event(None,[phrase]))
                      else: eList.append(optimise_partial_playing(CompositeEvent(map(lambda x:SampleEvent(partialsDirectory+os.sep+x,useExactLen=True),phrase))))
                    else: eList.append(phrase)
                    eList.append(Event(betweenPhrasePause))
                e = CompositeEvent(eList[:-1])
            elif partials_raw_mode: e=synth_event(None,s)
            else: e=optimise_partial_playing_list([CompositeEvent(map(lambda x:SampleEvent(partialsDirectory+os.sep+x,useExactLen=True),phrase)) for phrase in s])
            if not e:
                e=[]
                for phrase in s:
                    e.append(optimise_partial_playing(CompositeEvent(map(lambda x:SampleEvent(partialsDirectory+os.sep+x,useExactLen=True),phrase))))
                    e.append(Event(betweenPhrasePause))
                e=CompositeEvent(e[:-1])
            if not lessonIsTight(): e.length=math.ceil(e.length)
        elif s: e=SampleEvent(synthCache+os.sep+S(s))
        else:
            e=synth_event(languageof(fname),textof(fname))
            e.file = orig_DB+orig_fname
        e.is_prompt=(dirBase==B(promptsDirectory+os.sep))
    else: e=SampleEvent(dirBase+fname)
    e.setOnLeaves('wordToCancel',orig_fname)
    return e
transTbl = "TRANS"+extsep+"TBL"
if 0: pass # trimmed
if synthCache:
    if 0: pass # trimmed
    try: synthCache_contents = map(B,os.listdir(synthCache))
    except: synthCache_contents = synthCache = []
    for i in synthCache_contents:
        if i.upper()==B(transTbl):
            transTbl=S(i) ; break
    synthCache_contents = list2dict(synthCache_contents)
    if 0: pass # trimmed
synthCache_transtbl = {}
if synthCache and checkIn(B(transTbl),synthCache_contents):
    ensure_nodups = {}
    for l in open(synthCache+os.sep+transTbl,'rb').readlines():
        v,k = bwspstrip(l).split(None,1)
        if checkIn(v,ensure_nodups): del synthCache_transtbl[ensure_nodups[v]]
        ensure_nodups[v]=k ; synthCache_transtbl[k]=v
    del ensure_nodups
def textof(fname):
    fname = B(fname)
    return fname[fname.find(B('!synth:'))+7:fname.rfind(B('_'))]
last_partials_transliteration = None
synth_partials_cache = {} ; scl_disable_recursion = 0
def synthcache_lookup(fname,dirBase=None,printErrors=0,justQueryCache=0,lang=None):
    if dirBase==None: dirBase=samplesDirectory
    if dirBase: dirBase += os.sep
    if not lang: lang = languageof(fname)
    fname = B(fname)
    if fname.lower().endswith(B(dottxt)):
        try: fname = fname[:fname.rfind(B("_"))]+B("!synth:")+bwspstrip(u8strip(read(S(B(dirBase)+B(fname)))))+B("_")+B(lang)
        except IOError: return 0,0
    text = textof(fname)
    useSporadic = -1
    if justQueryCache: useSporadic,tryHarder=1,0
    else: tryHarder = not get_synth_if_possible(lang,0)
    if synthCache:
      for init in "_","":
        for ext in "wav","mp3":
            k=B(init)+text.lower()+B("_"+lang+extsep+ext)
            s=B(synthCache_transtbl.get(k,k))
            if checkIn(s,synthCache_contents): ret=s
            elif s.lower().endswith(B(dotwav)) and checkIn(s[:-len(dotwav)]+B(dotmp3),synthCache_contents): ret=s[:-len(dotwav)]+B(dotmp3)
            else: ret=0
            if ret:
                if justQueryCache==1: ret=(k,ret)
                if init=="_":
                    if useSporadic==-1: useSporadic=decide_subst_synth(text)
                    if useSporadic: return ret
                    elif tryHarder: tryHarder=ret
                else: return ret
    if justQueryCache==1: return 0,0
    if not checkIn(lang,synth_partials_voices): l,translit=None,None
    elif not checkIn((lang,text),synth_partials_cache):
        synth,translit = get_synth_if_possible(lang,0,to_transliterate=True),None
        if espeak_language_aliases.get(lang,lang) in ["zhy","zh-yue"]:
          text2=preprocess_chinese_numbers(fix_compatibility(ensure_unicode(text)),isCant=1).encode('utf-8')
          if ekho_speed_delta and type(get_synth_if_possible(lang,0))==EkhoSynth: return
        else: text2=text
        if synth: translit=synth.transliterate(lang,text2)
        if translit: t2=translit
        else: t2=text2
        if lang=="zh": t2=sort_out_pinyin_3rd_tones(pinyin_uColon_to_V(t2))
        phraseList = stripPuncEtc(t2.lower())
        l = [synth_from_partials(phrase,lang) for phrase in phraseList]
        if checkIn(None,l):
          global scl_disable_recursion
          if len(t2)<100 or not filter(lambda x:x,l) or scl_disable_recursion: l=None
          elif type(get_synth_if_possible(lang,0))==EkhoSynth: l=None
          else:
            t2=fix_compatibility(ensure_unicode(text2).replace(unichr(0),"").replace(u"\u3002",".").replace(u"\u3001",",")).encode('utf-8')
            for t in ".!?:;,": t2=t2.replace(B(t),B(t)+chr(0))
            l=[]
            scl_disable_recursion = 1
            for phrase in filter(lambda x:x,t2.split(chr(0))):
              ll=synthcache_lookup(B("!synth:")+phrase+B("_"+lang),dirBase,0,0,lang)
              if type(ll)==type([]): l += ll
              else: l.append(synth_event(lang,phrase,0))
            scl_disable_recursion = 0
        synth_partials_cache[(lang,text)]=(l,translit)
    else: l,translit=synth_partials_cache[(lang,text)]
    if l and partials_are_sporadic:
        if useSporadic==-1: useSporadic=decide_subst_synth(("partials",text))
        if not useSporadic: l=translit=None
    if l and translit:
        global last_partials_transliteration
        last_partials_transliteration=translit
    if l: return l
    if tryHarder and not tryHarder==True: return tryHarder
    if printErrors and synthCache and not (app and winsound):
        r = repr(text.lower()+B("_"+lang))
        if len(r)>100: r=r[:100]+"..."
        global NICcount
        try: NICcount += 1
        except: NICcount=1
        if NICcount>20: pass
        elif NICcount==20: show_info("Further 'not in cache' warnings turned off\n",True) # (important on S60 etc; TODO configurable?)
        else: show_info("Not in cache: "+r+"\n",True)
def can_be_synthesized(fname,dirBase=None,lang=None):
    if dirBase==None: dirBase=samplesDirectory
    if dirBase: dirBase += os.sep
    if not lang: lang = languageof(fname)
    if get_synth_if_possible(lang,0): return True
    elif synthcache_lookup(fname,dirBase,1,2,lang): return True
    else: return get_synth_if_possible(lang)
def stripPuncEtc(text):
    text = B(text)
    for t in " -_'\"()[]": text=text.replace(B(t),B(""))
    for t in ".!?:;": text=text.replace(B(t),B(","))
    return filter(lambda x:x,text.split(B(",")))
for zipToCheck in ["yali-voice","yali-lower","cameron-voice"]:
    if 0: pass # trimmed
    elif not winsound:
        for d in [os.getcwd()+cwd_addSep,".."+os.sep,samplesDirectory+os.sep]:
            f=d+zipToCheck+".exe"
            if fileExists(f):
                unzip_and_delete(f,ignore_fail=1)
                try: os.unlink("setup.bat")
                except: pass
non_normal_filenames = {} ; using_unicode_filenames=0
def filename2unicode(f): pass # trimmed
def unicode2filename(u): pass # trimmed
synth_partials_voices = {}
partials_cache_file="partials-cache"+extsep+"bin"
partials_language_aliases = {}
if partialsDirectory and isDirectory(partialsDirectory):
  dirsToStat = []
  partialsCacheFormat="(partials_raw_mode,synth_partials_voices,guiVoiceOptions,audioDataPartials,dirsToStat,espeak_language_aliases,partials_language_aliases)"
  if pickle and fileExists(partials_cache_file):
    try:
        ela = espeak_language_aliases
        format,values = pickle.Unpickler(open(partials_cache_file,"rb")).load()
        if format==partialsCacheFormat: exec (format+"=values")
        if not (ela==espeak_language_aliases and dirsToStat[0][0]==partialsDirectory): espeak_language_aliases,dirsToStat=ela,[]
        del ela,format,values
    except MemoryError: raise
    except: dirsToStat = []
    for d,result in dirsToStat:
      if not tuple(os.stat(d))==result:
        dirsToStat=[] ; break
  if not dirsToStat:
    if riscos_sound or winCEsound: show_info("Scanning partials... ")
    guiVoiceOptions = []
    langs = os.listdir(partialsDirectory)
    dirsToStat.append((partialsDirectory,os.stat(partialsDirectory)))
    audioDataPartials = {} ; synth_partials_voices = {}
    partials_raw_mode = checkIn("header"+dotwav,langs)
    for l in langs:
        try: voices = os.listdir(partialsDirectory+os.sep+l)
        except: voices = []
        if voices: dirsToStat.append((partialsDirectory+os.sep+l,os.stat(partialsDirectory+os.sep+l)))
        thisLangVoices = [] ; voices.sort()
        for v in voices:
            if "-" in v and v[:v.index("-")] in voices:
              suffix=v[v.index("-"):]
              if not checkIn(suffix,guiVoiceOptions): guiVoiceOptions.append(suffix)
            start,mid,end = [],[],[] ; flags=0
            try: files = os.listdir(partialsDirectory+os.sep+l+os.sep+v)
            except: files = []
            if files: dirsToStat.append((partialsDirectory+os.sep+l+os.sep+v,os.stat(partialsDirectory+os.sep+l+os.sep+v)))
            def addFile(f):
                global flags
                if riscos_sound and "." in f: f=f.replace(".",extsep) # in case made filelist on another system
                if f=="!calibrated":
                    flags|=1
                if partials_raw_mode and f=="header"+dotwav:
                    flags|=2
                if f=="audiodata"+extsep+"dat": # parse audiodata.dat
                    dirsToStat.append((partialsDirectory+os.sep+l+os.sep+v+os.sep+f,os.stat(partialsDirectory+os.sep+l+os.sep+v+os.sep+f)))
                    offset=0 ; f=l+os.sep+v+os.sep+f
                    ff=open(partialsDirectory+os.sep+f,"rb")
                    amend = []
                    while True:
                        fftell = ff.tell()
                        char = ff.read(1)
                        if not B("0")<=char<=B("9"): break
                        size,fname = bwspstrip(char+ff.readline(256)).split(None,1)
                        try: size=int(size)
                        except: break
                        fname = S(fname)
                        addFile(fname)
                        amend.append(l+os.sep+v+os.sep+fname)
                        audioDataPartials[l+os.sep+v+os.sep+fname] = (f,offset,size)
                        offset += size
                    for k in amend: audioDataPartials[k]=(audioDataPartials[k][0],audioDataPartials[k][1]+fftell,audioDataPartials[k][2])
                    del ff,amend,offset
                if partials_raw_mode:
                    if not f.endswith(extsep+"raw"): return
                elif not f.endswith(dotwav) or f.endswith(dotmp3): return
                if f.find("-s")>=0 or f.find("-i")>=0: start.append(f)
                elif not "-" in f or f.find('-m')>=0: mid.append(f)
                elif f.find('-e')>=0 or f.find('-f')>=0: end.append(f) # 'end' or 'finish'
            for f in files: addFile(f)
            def byReverseLength(a,b): return len(b)-len(a)
            sort(start,byReverseLength) ; sort(mid,byReverseLength) ; sort(end,byReverseLength)
            def toDict(l):
                if not l: return {}
                l2 = [] ; kLen = len(l[0])
                for i in l:
                    if "-" in i: key=i[:i.index("-")]
                    else: key=i[:i.rindex(extsep)]
                    if key.find("_u")>=0 or key.find("_U")>=0: # a unicode partial with a portable filename?
                        key = filename2unicode(key).encode('utf-8')
                    l2.append((key,i))
                    kLen=min(kLen,len(key))
                l = {}
                for k,i in l2:
                    if not checkIn(k[:kLen],l): l[k[:kLen]]=[]
                    l[k[:kLen]].append((k,i))
                return l
            thisLangVoices.append((v,toDict(start),toDict(mid),toDict(end),flags))
        synth_partials_voices[l] = thisLangVoices
        if checkIn(l,espeak_language_aliases): partials_language_aliases[espeak_language_aliases[l]]=l
    if riscos_sound or winCEsound: show_info("done\n")
    if pickle:
      try: pickle.Pickler(open(partials_cache_file,"wb"),-1).dump((partialsCacheFormat,eval(partialsCacheFormat)))
      except IOError: pass
      except OSError: pass
  if partials_raw_mode:
    (wtype,wrate,wchannels,wframes,wbits) = swhat(partialsDirectory+os.sep+"header"+dotwav)
    partials_raw_0bytes = int(betweenPhrasePause*wrate)*wchannels*int(wbits/8)
else: synth_partials_voices,partials_raw_mode = {},None
if checkIn("cant",synth_partials_voices): synth_partials_voices["zhy"]=synth_partials_voices["zh-yue"]=synth_partials_voices["cant"]
def partials_langname(lang):
    lang = espeak_language_aliases.get(lang,lang)
    lang = partials_language_aliases.get(lang,lang)
    return lang
def synth_from_partials(text,lang,voice=None,isStart=1):
    lang = partials_langname(lang)
    text=bwspstrip(B(text))
    if lang=="zh": # hack for Mandarin - higher tone 5 after a tone 3 (and ma5 after 4 or 5 also)
        lastNum = None
        for i in range(len(text)):
            if text[i:i+1] in B("123456"):
                if text[i:i+1]==B("5") and (lastNum==B("3") or (lastNum and lastNum>B("3") and i>2 and text[i-2:i+1]==B("ma5"))): # (TODO ne5 also? but only if followed by some form of question mark, and that might have been dropped)
                    r=synth_from_partials(text[:i]+B("6")+text[i+1:],lang,voice,isStart)
                    if r: return r
                    else: break
                elif lastNum: break
                lastNum = text[i:i+1]
    if not voice:
        if not checkIn(lang,synth_partials_voices): return None
        needCalibrated=False
        if lang=="zh": # hack for Mandarin - avoid consecutive 1st tones on non-calibrated voices
            lastNum=None
            for i in xrange(len(text)):
                c = text[i:i+1]
                if c==B("1") and lastNum==B("1"):
                    needCalibrated=True ; break
                if c in B("123456"): lastNum=c
        vTry = synth_partials_voices[lang]
        if voiceOption:
            vt1=[] ; vt2=[]
            for v in vTry:
              if v[0].endswith(voiceOption): vt1.append(v)
              else: vt2.append(v)
            vTry=vt1+vt2
        for v in vTry:
            if needCalibrated and not v[-1]&1: continue
            r = synth_from_partials(text,lang,v)
            if r:
                if partials_raw_mode and v[-1]&2: r.insert(0,"header"+dotwav)
                return map(lambda x,v=v,lang=lang:lang+os.sep+v[0]+os.sep+x,r)
        return None
    dir, start, mid, end, flags = voice
    def lookup_dic(text,dic):
        text = S(text)
        if dic:
            for k,v in dic.get(text[:len(list(dic.keys())[0])],[]):
                if text.startswith(k): return k,v
        return None,None
    if not text: return []
    k,v = lookup_dic(text,end)
    if text==k: return [v]
    if isStart: preferredOrder = [start, mid]
    else: preferredOrder = [mid, start]
    for l in preferredOrder:
        k,v = lookup_dic(text,l)
        if k:
            if text==k: return [v]
            rest = synth_from_partials(text[len(k):],lang,voice,0)
            if rest==None: return None
            else: return [v]+rest
    if not get_synth_if_possible(lang,0):
        global warned_missing_chars
        if not warned_missing_chars: show_warning("Warning: Partials synth is IGNORING unrecognised characters in the input, because there is no fallback synth")
        warned_missing_chars=1
        return synth_from_partials(text[1:],lang,voice)
warned_missing_chars=0
def optimise_partial_playing(ce): pass # trimmed
def simplified_header(*_): pass # trimmed
def optimise_partial_playing_list(*_): pass # trimmed
def init_scanSamples():
  global limitedFiles,dirsWithIntros,filesWithExplanations,singleLinePoems,variantFiles
  limitedFiles = {}
  dirsWithIntros = []
  filesWithExplanations = {}
  singleLinePoems = {}
  variantFiles = {}
init_scanSamples() ; emptyCheck_hack = 0
def scanSamples(directory=None):
    if not directory: directory=samplesDirectory
    retVal = []
    if not emptyCheck_hack: doLabel("Scanning samples")
    if import_recordings_from: import_recordings()
    scanSamples_inner(directory,retVal,0)
    return retVal
def words_exist(): pass # trimmed
class CannotOverwriteExisting(Exception): pass
def import_recordings(*_): pass # trimmed
def exec_in_a_func(x):
   d={"firstLanguage":firstLanguage,"secondLanguage":secondLanguage}
   exec (x,d)
   return d["secondLanguage"],d["firstLanguage"]
def check_has_variants(directory,ls):
    if directory==promptsDirectory: return True
    else:
        for file in ls:
            if (file+extsep)[:file.rfind(extsep)]==variants_filename: return True
def getLsDic(directory):
    if not (directory.find(exclude_from_scan)==-1): return {}
    try: ls = os.listdir(directory)
    except: return {}
    if checkIn("settings"+dottxt,ls):
        oddLanguage,evenLanguage = exec_in_a_func(wspstrip(u8strip(read(directory+os.sep+"settings"+dottxt).replace(B("\r\n"),B("\n")))))
        if oddLanguage==evenLanguage: oddLanguage,evenLanguage="_"+oddLanguage,"-meaning_"+evenLanguage
        else: oddLanguage,evenLanguage="_"+oddLanguage,"_"+evenLanguage
        for f in ls:
            if "_" in f or not extsep in f: continue
            i=f.rfind(extsep)
            while i>0 and f[i-1] in "0123456789": i-=1
            num=f[i:f.rfind(extsep)]
            if not num: continue
            os.rename(directory+os.sep+f,directory+os.sep+f[:i]+(("%0"+str(len(str(len(ls))))+"d") % (int((int(num)-1)/2)*2+1))+cond(int(num)%2,oddLanguage,evenLanguage)+f[f.rfind(extsep):])
        os.remove(directory+os.sep+"settings"+dottxt)
        ls = os.listdir(directory)
    ls.sort()
    lsDic = {}
    has_variants = check_has_variants(directory,ls)
    for file in ls:
        filelower = file.lower()
        if filelower.endswith(dottxt) and checkIn((file+extsep)[:file.rfind(extsep)],lsDic): continue
        if has_variants and file.find("_",file.find("_")+1)>=0: languageOverride=file[file.find("_")+1:file.find("_",file.find("_")+1)] # for can_be_synthesized below
        else: languageOverride=None
        if (filelower.endswith(dottxt) and file.find("_")>=0 and can_be_synthesized(file,directory,languageOverride)) or filelower.endswith(dotwav) or filelower.endswith(dotmp3): val = file
        else:
            val = ""
            if filelower.endswith(extsep+"zip"): show_warning("Warning: Ignoring "+file+" (please unpack it first)") # so you can send someone a zip file for their recorded words folder and they'll know what's up if they don't unpack it
            elif isDirectory(directory+os.sep+file):
                lsDic[file]=None
                continue
            elif checkIn((file+extsep)[:file.rfind(extsep)],lsDic): continue
        lsDic[(file+extsep)[:file.rfind(extsep)]] = val
    if has_variants:
        ls=list2set(ls)
        newVs = {}
        for k,v in list(lsDic.items()):
            if not v or (not directory==promptsDirectory and v.find("_explain_")>=0): continue
            last_ = v.rfind("_")
            if last_==-1: continue
            penult_ = v.rfind("_",0,last_)
            if penult_==-1: continue
            del lsDic[k]
            newK,newV = k[:k.rfind("_")], v[:v.rfind("_")]+v[v.rfind(extsep):]
            new_dirV = B(directory)+B(os.sep)+B(newV)
            if not checkIn(newK,lsDic):
                lsDic[newK] = newV
                assert not checkIn(new_dirV,variantFiles)
                variantFiles[new_dirV] = [v]
            elif v.endswith(dottxt) and not lsDic[newK].endswith(dottxt):
                old_dirV = B(directory+os.sep+lsDic[newK])
                if checkIn(old_dirV,variantFiles):
                    d = variantFiles[old_dirV]
                    del variantFiles[old_dirV]
                    variantFiles[new_dirV] = d
                else: variantFiles[new_dirV] = [B(lsDic[newK])]
                variantFiles[new_dirV].append(v)
                if checkIn(old_dirV,newVs):
                    del newVs[old_dirV]
                newVs[new_dirV] = 1
                lsDic[newK] = newV
            else:
                newV = lsDic[newK]
                new_dirV = B(directory)+B(os.sep)+B(newV)
                if not checkIn(new_dirV,variantFiles):
                    variantFiles[new_dirV] = [B(newV)]
                variantFiles[new_dirV].append(v)
            newVs[new_dirV]=1
        for v in list(newVs.keys()):
            assert checkIn(v,variantFiles), repr(sorted(list(variantFiles.keys())))+' '+repr(v)
            random.shuffle(variantFiles[v])
    return lsDic
def scanSamples_inner(directory,retVal,doLimit):
    firstLangSuffix = "_"+firstLanguage
    secLangSuffix = "_"+secondLanguage
    lsDic = getLsDic(directory)
    intro = intro_filename+"_"+firstLanguage
    if checkIn(intro,lsDic): dirsWithIntros.append((directory[len(samplesDirectory)+len(os.sep):],lsDic[intro]))
    if not doLimit: doLimit = checkIn(limit_filename,lsDic)
    doPoetry = checkIn(poetry_filename,lsDic)
    if doPoetry:
        def poetry_language(firstLangSuffix,secLangSuffix,lsDic):
         ret = ""
         for file,withExt in list(lsDic.items()):
          if withExt:
            if file.endswith(secLangSuffix): ret=secLangSuffix
            elif (not file.endswith(firstLangSuffix)):
                llist = [firstLanguage,secondLanguage]+otherFirstLanguages
                for l in otherLanguages:
                    if not l in llist and file.endswith("_"+l): return "_"+l
         return ret
        doPoetry = poetry_language(firstLangSuffix,secLangSuffix,lsDic)
    prefix = directory[len(samplesDirectory)+cond(samplesDirectory,len(os.sep),0):]
    if prefix: prefix += os.sep
    lastFile = None
    items = list(lsDic.items()) ; items.sort()
    for file,withExt in items:
        swapWithPrompt = 0
        if not withExt:
            lastFile = None
            if withExt==None and (cache_maintenance_mode or not directory+os.sep+file==promptsDirectory):
                scanSamples_inner(directory+os.sep+file,retVal,doLimit)
                if emptyCheck_hack and retVal: return
        elif file.find("_")==-1: continue
        elif (doPoetry and file.endswith(doPoetry)) or (not doPoetry and (not file.endswith(firstLangSuffix) or firstLanguage==secondLanguage)):
            if file.endswith(secLangSuffix): wordSuffix=secLangSuffix
            else:
                wordSuffix=None
                for l in otherLanguages:
                    if not l in [firstLanguage,secondLanguage] and file.endswith("_"+l):
                        if checkIn(l,otherFirstLanguages): swapWithPrompt=1
                        wordSuffix="_"+l ; break
                if not wordSuffix: continue
            if swapWithPrompt or firstLanguage==secondLanguage: promptFile=None
            else: promptFile = lsDic.get(file[:-len(wordSuffix)]+firstLangSuffix,0)
            explanationFile = lsDic.get(file[:-len(wordSuffix)]+wordSuffix+"_explain_"+firstLanguage,0)
            if not promptFile and not wordSuffix==secLangSuffix:
                promptFile = lsDic.get(file[:-len(wordSuffix)]+secLangSuffix,0)
            if not promptFile:
                promptFile = lsDic.get(file[:-len(wordSuffix)]+"-meaning"+wordSuffix,0)
            if promptFile:
                if swapWithPrompt: promptFile,withExt = withExt,promptFile
                if doPoetry and lastFile:
                    if lastFile[0]: promptToAdd = [prefix+lastFile[0], prefix+promptFile, prefix+lastFile[1]]
                    else: promptToAdd = [prefix+lastFile[1], prefix+promptFile]
                else: promptToAdd = prefix+promptFile
            elif doPoetry:
                if lastFile:
                    promptToAdd = prefix+lastFile[-1]
                    if checkIn(promptToAdd,singleLinePoems): del singleLinePoems[promptToAdd]
                else:
                    promptToAdd = prefix+withExt
                    singleLinePoems[promptToAdd]=1
            elif cache_maintenance_mode: promptToAdd = prefix+withExt
            else: continue
            retVal.append((0,promptToAdd,prefix+withExt))
            if emptyCheck_hack: return
            if explanationFile: filesWithExplanations[prefix+withExt]=explanationFile
            if doLimit: limitedFiles[B(prefix+withExt)]=prefix
            lastFile = [promptFile,withExt]
cache_maintenance_mode=0
def parseSynthVocab(fname,forGUI=0):
    if not fname: return []
    langs = [secondLanguage,firstLanguage] ; someLangsUnknown = 0 ; maxsplit = 1
    ret = []
    count = 1 ; doLimit = 0 ; limitNo = 0 ; doPoetry = disablePoem = 0
    lastPromptAndWord = None
    if not fileExists(fname): return []
    if not emptyCheck_hack: doLabel("Reading "+fname)
    allLangs = list2set([firstLanguage,secondLanguage]+otherLanguages)
    for l in u8strip(read(fname)).replace(B("\r"),B("\n")).split(B("\n")):
        if not B("=") in l: # might be a special instruction
            if not l: continue
            canProcess = 0 ; l2=bwspstrip(l)
            if not l2 or l2[0:1]==B('#'): continue
            l2=l2.lower()
            if l2.startswith(B("set language ")) or l2.startswith(B("set languages ")):
                langs=map(S,l.split()[2:]) ; someLangsUnknown = 0
                maxsplit = len(langs)-1
                for l in langs:
                    if not checkIn(l,allLangs): someLangsUnknown = 1
            elif l2.startswith(B("limit on")):
                doLimit = 1 ; limitNo += 1
            elif l2.startswith(B("limit off")): doLimit = 0
            elif l2.startswith(B("begin poetry")): doPoetry,lastPromptAndWord,disablePoem = True,None,False
            elif l2.startswith(B("end poetry")): doPoetry = lastPromptAndWord = None
            elif l2.startswith(B("poetry vocab line")): doPoetry,lastPromptAndWord = 0,cond(lastPromptAndWord,lastPromptAndWord,0) # not None, in case we're at the very start of a poem (see "just processed"... at end)
            else: canProcess=1
            if not canProcess: continue
        elif B('#') in l and bwspstrip(l)[0:1]==B('#'): continue # guard condition "'#' in l" improves speed
        if forGUI: strCount=""
        else:
            strCount = "%05d!synth:" % (count,)
            count += 1
        langsAndWords = list(zip(langs,l.split(B("="),maxsplit)))
        if someLangsUnknown: langsAndWords = filter(lambda x,a=allLangs:checkIn(x[0],a), langsAndWords)
        if firstLanguage==secondLanguage: langsAlreadySeen = {}
        else: langsAlreadySeen = {firstLanguage:True}
        def findPrompt(langsAndWords,langsAlreadySeen,doPoetry,strCount):
            i=0
            while i<len(langsAndWords):
                lang,word = langsAndWords[i] ; i += 1
                isReminder = cache_maintenance_mode and len(langsAndWords)==1 and not doPoetry
                if (lang in langsAlreadySeen or isReminder) and (lang in getsynth_cache or can_be_synthesized(B("!synth:")+B(word)+B("_")+B(lang))): # (check cache because most of the time it'll be there and we don't need to go through all the text processing in can_be_synthesized)
                    if not word: continue
                    elif word[0:1] in bwsp or word[-1:] in bwsp: word=bwspstrip(word)
                    return B(strCount)+word+B("_"+lang), cond(isReminder,0,i)
                langsAlreadySeen[lang]=True
            return None,0
        prompt,onePastPromptIndex = findPrompt(langsAndWords,langsAlreadySeen,doPoetry,strCount)
        if not prompt and len(langsAndWords)>1:
            langsAlreadySeen = list2dict(otherFirstLanguages) ; prompt,onePastPromptIndex = findPrompt(langsAndWords,langsAlreadySeen,doPoetry,strCount)
            if not prompt:
                langsAlreadySeen = {secondLanguage:True} ; prompt,onePastPromptIndex = findPrompt(langsAndWords,langsAlreadySeen,doPoetry,strCount)
        prompt_L1only = prompt
        if doPoetry:
            if prompt and lastPromptAndWord:
                if lastPromptAndWord[0]: prompt=[S(lastPromptAndWord[0]),S(prompt),S(lastPromptAndWord[1])]
                else: prompt=[S(lastPromptAndWord[1]),S(prompt)]
            elif not prompt:
                if lastPromptAndWord:
                    prompt=lastPromptAndWord[-1]
                    if checkIn(lastPromptAndWord[-1],singleLinePoems): del singleLinePoems[lastPromptAndWord[-1]]
                else:
                    prompt = 1
        if prompt:
            i=0
            while i<len(langsAndWords):
                lang,word = langsAndWords[i] ; i+=1
                if i==onePastPromptIndex or (lang==firstLanguage and not firstLanguage==secondLanguage) or not word: continue
                elif word[0:1] in bwsp or word[-1:] in bwsp: word=bwspstrip(word)
                if checkIn(lang,getsynth_cache) or can_be_synthesized(B("!synth:")+word+B("_"+lang)):
                  if not (doPoetry and disablePoem):
                    f=B(strCount)+word+B("_"+lang)
                    if prompt==1 or prompt==f:
                        prompt=f
                        singleLinePoems[f]=1
                    ret.append((0,S(prompt),S(f)))
                    if emptyCheck_hack: return ret
                    if doLimit: limitedFiles[f]=B("synth:"+str(limitNo))
                    if doPoetry: lastPromptAndWord = [prompt_L1only,f]
                elif doPoetry: disablePoem=1
        if not lastPromptAndWord==None: doPoetry = 1
    return ret
def sanitise_otherLanguages():
    for l in otherFirstLanguages:
        if not checkIn(l,otherLanguages): otherLanguages.append(l)
    for l in otherLanguages:
        if not checkIn(l,possible_otherLanguages): possible_otherLanguages.append(l)
sanitise_otherLanguages()
class MessageException(Exception):
    def __init__(self,message): self.message = message
    def __repr__(self): return self.message
class PromptException(MessageException): pass
auto_advancedPrompt=0
class AvailablePrompts(object):
    reservedPrefixes = list2set(map(lambda x:x.lower(),["whatmean","meaningis","repeatAfterMe","sayAgain","longPause","begin","end",firstLanguage,secondLanguage] + possible_otherLanguages))
    def __init__(self):
        self.lsDic = getLsDic(promptsDirectory)
        self.prefixes = {}
        for k,v in list(self.lsDic.items()):
            if v: self.prefixes[k[:k.rfind("_")]]=1 # delete language
            else: del self.lsDic[k]
        self.prefixes = list(self.prefixes.keys())
        self.user_is_advanced = None
    def getRandomPromptList(self,promptsData,language):
        random.shuffle(self.prefixes)
        for p in self.prefixes:
            if checkIn(p.lower(),self.reservedPrefixes): continue
            try:
                theList = self.getPromptList(p,promptsData,language)
                return theList
            except PromptException: pass
        raise PromptException("Can't find a non-reserved prompt suitable for language '%s'. Try creating tryToSay_%s%s etc in %s" % (language,language,dotwav,promptsDirectory))
    def getPromptList(self,prefix,promptsData,language):
        if self.user_is_advanced==None:
            self.user_is_advanced = 0
            for p in promptsData.values():
                if p > advancedPromptThreshold2:
                    self.user_is_advanced = 1 ; break
        beginnerPrompt = prefix+"_"+firstLanguage
        if not checkIn(beginnerPrompt,self.lsDic):
            if self.user_is_advanced and not language==secondLanguage and prefix+"_"+secondLanguage in self.lsDic: beginnerPrompt=prefix+"_"+secondLanguage
            else: beginnerPrompt = None
        advancedPrompt = prefix+"_"+language
        if not checkIn(advancedPrompt,self.lsDic):
            if beginnerPrompt: r=[self.lsDic[beginnerPrompt]]
            else:
                if language in [firstLanguage,secondLanguage]: raise PromptException("Can't find "+prefix+"_"+firstLanguage+" or "+prefix+"_"+secondLanguage)
                else: raise PromptException("Can't find "+prefix+"_"+language+", "+prefix+"_"+firstLanguage+" or "+prefix+"_"+secondLanguage)
        elif not beginnerPrompt:
            if (not self.user_is_advanced) and not auto_advancedPrompt and cond(language==secondLanguage,advancedPromptThreshold,advancedPromptThreshold2): raise PromptException("Prompt '%s' is too advanced; need '%s_%s' (unless you set %s=0 in advanced%stxt)" % (advancedPrompt,prefix,firstLanguage,cond(language==secondLanguage,"advancedPromptThreshold","advancedPromptThreshold2"),extsep))
            r=[self.lsDic[advancedPrompt]]
        elif promptsData.get(advancedPrompt,0) >= cond(language==secondLanguage,advancedPromptThreshold,advancedPromptThreshold2): r=[self.lsDic[advancedPrompt]]
        elif promptsData.get(advancedPrompt,0) >= cond(language==secondLanguage,transitionPromptThreshold,transitionPromptThreshold2): r=[self.lsDic[advancedPrompt], self.lsDic[beginnerPrompt]]
        else: r=[self.lsDic[beginnerPrompt]]
        adv = promptsData.get(advancedPrompt,0)
        if checkIn(advancedPrompt,self.lsDic) or adv <= cond(language==secondLanguage,transitionPromptThreshold,transitionPromptThreshold2):
            adv += 1
        promptsData[advancedPrompt] = adv
        if not language==secondLanguage and not prefix==language and not prefix=="meaningis": r=self.getPromptList(language,promptsData,language)+r
        return r
def introductions(zhFile,progressData):
    toIntroduce = []
    for d,fname in dirsWithIntros[:]:
        found = 0
        for p in progressData:
            if B(p[-1]).startswith(B(d)) and p[0]:
                found=1 ; dirsWithIntros.remove((d,fname)) ; break
        if found: continue
        if B(zhFile).startswith(B(d)): toIntroduce.append((d,fname))
    toIntroduce.sort()
    return map(lambda x: fileToEvent(cond(x[0],x[0]+os.sep,"")+x[1]), toIntroduce)
def explanations(zhFile):
    if checkIn(zhFile,filesWithExplanations): return fileToEvent(zhFile.replace(dotmp3,dotwav).replace(dottxt,dotwav).replace(dotwav,"_explain_"+firstLanguage+filesWithExplanations[zhFile][-len(dotwav):]))
try: import tkSnack
except: tkSnack = 0
class InputSource(object): pass # trimmed
class MicInput(InputSource): pass # trimmed
class PlayerInput(InputSource): pass # trimmed
if 0: pass # trimmed
class InputSourceManager(object): pass # trimmed
theISM = InputSourceManager() ; del InputSourceManager
def wavToMp3(*_): pass # trimmed
def makeMp3Zips(*_): pass # trimmed
def getAmplify(*_): pass # trimmed
def doAmplify(*_): pass # trimmed
class ButtonScrollingMixin(object): pass # trimmed
class RecorderControls(ButtonScrollingMixin): pass # trimmed
def reviseCount(*_): pass # trimmed
def doRecWords(): pass # trimmed
def android_recordFile(*_): pass # trimmed
def android_recordWord(): pass # trimmed
def s60_recordWord():
    def ipFunc(prompt,value=u""): return appuifw.query(prompt,"text",value)
    droidOrS60RecWord(s60_recordFile,ipFunc)
def droidOrS60RecWord(recFunc,inputFunc):
 if secondLanguage==firstLanguage: l1Suffix, l1Display = firstLanguage+"-meaning_"+firstLanguage, "meaning"
 else: l1Suffix, l1Display = firstLanguage, firstLanguage
 while True:
  l2 = recFunc(secondLanguage)
  if not l2: return
  l1 = None
  while not l1:
    if (not maybeCanSynth(firstLanguage)) or getYN("Record "+l1Display+" too? (else computer voice)"): l1 = recFunc(l1Suffix)
    else:
       l1txt = inputFunc(u""+firstLanguage+" text:")
       if l1txt:
          l1 = "newfile_"+firstLanguage+dottxt
          open(l1,"w").write(l1txt.encode("utf-8"))
    if not l1 and getYN("Discard the "+secondLanguage+" recording?"):
       os.remove(l2) ; break
  if not l1: continue
  ls = list2set(os.listdir(samplesDirectory))
  def inLs(prefix,ls):
    for l in ls:
        if l.startswith(prefix) and len(l) > len(prefix) and l[len(prefix)] not in "0123456789": return True
  global recCount
  try: recCount += 1
  except: recCount = 1
  while inLs("%02d" % recCount,ls): recCount += 1
  origPrefix = prefix = ensure_unicode("%02d" % recCount)
  while True:
    prefix = inputFunc(u"Filename:",prefix)
    if not prefix:
      if getYN("Discard this recording?"):
        recCount-=1;os.remove(l1);os.remove(l2);return
      else:
        prefix = origPrefix ; continue
    if not inLs(prefix,ls) or getYN("File exists.  overwrite?"): break
  if samplesDirectory: prefix=samplesDirectory+os.sep+prefix
  os.rename(l1,prefix+l1[l1.index("_"):])
  os.rename(l2,prefix+l2[l2.index("_"):])
  if not getYN("Record another?"): break
def s60_recordFile(language):
 fname = "newfile_"+language+dotwav
 while True:
  S=audio.Sound.open(os.getcwd()+os.sep+fname)
  def forgetS(fname,S):
    S.close()
    try: os.remove(fname)
    except: pass
  if not getYN("Press OK to record "+language+" word"): return forgetS(fname,S)
  S.record()
  ret = getYN("Press OK to stop") ; S.stop()
  if not ret:
    forgetS(fname,S) ; continue
  S.play()
  ret = getYN("Are you happy with this?")
  S.stop() ; S.close()
  if not ret:
    os.remove(fname) ; continue
  return fname
settingsFile = "settings"+dottxt
user0 = (samplesDirectory,vocabFile,progressFile,progressFileBackup,pickledProgressFile,settingsFile)
def addUserToFname(*_): pass # trimmed
def select_userNumber(*_): pass # trimmed
def select_userNumber2(N): pass # trimmed
def setup_samplesDir_ifNec(*_): pass # trimmed
def get_userNames(): pass # trimmed
def set_userName(*_): pass # trimmed
def wrapped_set_userName(*_): pass # trimmed
GUI_usersRow = lastUserNames = None
def updateUserRow(*_): pass # trimmed
def renameUser(*_): pass # trimmed
def deleteUser(i): pass # trimmed
def interrupt_instructions():
    if soundCollector or app or appuifw or android: return ""
    else: return "\nPress Control-C if you have to interrupt the lesson."
appTitle += time.strftime(" %A")
def waitOnMessage(msg):
    global warnings_printed
    if type(msg)==type(u""): msg2=msg.encode("utf-8")
    else:
        try: msg2,msg=msg,msg.decode("utf-8")
        except AttributeError: msg2=msg
    if appuifw:
        t=appuifw.Text() ; t.add(u"".join(warnings_printed)+msg) ; appuifw.app.body = t
        appuifw.query(msg,'query')
    else:
        if clearScreen(): msg2 = B("This is "+program_name.replace("(c)","\n(c)")+"\n\n")+msg2 # clear screen is less confusing for beginners, but NB it may not happen if warnings etc
        show_info(msg2+B("\n\n"+cond(winCEsound,"Press OK to continue\n","Press Enter to continue\n")))
        sys.stderr.flush()
        try:
            raw_input(cond(winCEsound,"See message under this window.","")) # (WinCE uses boxes for raw_input so may need to repeat the message - but can't because the prompt is size-limited, so need to say look under the window)
            clearScreen()
        except EOFError: show_info("EOF on input - continuing\n")
    warnings_printed = []
def getYN(msg,defaultIfEof="n"):
    if appuifw:
        appuifw.app.body = None
        return appuifw.query(ensure_unicode(msg),'query')
    else:
        ans=None
        clearScreen()
        while not ans=='y' and not ans=='n':
            try: ans = raw_input("%s\nPress y for yes, or n for no.  Then press Enter.  --> " % (msg,))
            except EOFError:
                ans=defaultIfEof ; print (ans)
        clearScreen()
        if ans=='y': return 1
        return 0
def primitive_synthloop():
    global justSynthesize,warnings_printed
    lang = None
    interactive = appuifw or winCEsound or android or not hasattr(sys.stdin,"isatty") or sys.stdin.isatty()
    if interactive: interactive=cond(winCEsound and warnings_printed,"(see warnings under this window) Say:","Say: ") # (WinCE uses an input box so need to repeat the warnings if any - but can't because prompt is size-limited, so need to say move the window.)
    else: interactive="" # no prompt on the raw_input (we might be doing outputFile="-" as well)
    while True:
        old_js = justSynthesize
        if appuifw:
            if not justSynthesize: justSynthesize=""
            justSynthesize=appuifw.query(u"Say:","text",ensure_unicode(justSynthesize))
            if justSynthesize: justSynthesize=justSynthesize.encode("utf-8")
            else: break
        else:
            if 0: pass # trimmed
            else:
              try: justSynthesize=raw_input(interactive)
              except EOFError: break
            if (winCEsound or riscos_sound or android) and not justSynthesize: break
            if interactive and not readline:
              interactive="('a' for again) Say: "
              if B(justSynthesize)==B("a"): justSynthesize=old_js
        oldLang = lang
        if justSynthesize: lang = S(just_synthesize(interactive,lang))
        if justSynthesize and lang and not B('#') in B(justSynthesize):
            if B(justSynthesize).startswith(B(lang)+B(" ")):
                t = transliterates_differently(justSynthesize[len(lang+" "):],lang)
                if t: t=lang+" "+t
            else: t = transliterates_differently(justSynthesize,lang)
            if t:
                if appuifw: justSynthesize = t
                else: show_info(B("Spoken as ")+t+B("\n"))
        if warnings_printed:
            if appuifw:
                t=appuifw.Text()
                t.add(u"".join(warnings_printed))
                appuifw.app.body = t
            warnings_printed = []
        if not lang: lang=oldLang
if 0: pass # trimmed
def startBrowser(url):
  if 0: pass # trimmed
  try:
      import webbrowser
      g=webbrowser.get()
  except: g=0
  if g and (winCEsound or macsound or (hasattr(g,"background") and g.background) or (hasattr(webbrowser,"BackgroundBrowser") and g.__class__==webbrowser.BackgroundBrowser) or (hasattr(webbrowser,"Konqueror") and g.__class__==webbrowser.Konqueror)):
      return g.open_new(S(url))
  if 0: pass # trimmed
def clearScreen():
    global warnings_printed
    if not (winsound or mingw32 or unix): return
    if warnings_printed:
        warnings_printed = []
        return
    if 0: pass # trimmed
    else: os.system("clear >&2") # (>&2 in case using stdout for something else)
    return True
cancelledFiles = []
def handleInterrupt():
    needCountItems = 0
    if saveProgress:
        if dbase and not dbase.saved_completely:
            show_info("Calculating partial progress... ") # (normally quite quick but might not be on PDAs etc, + we want this written if not app)
            needCountItems = 1
        elif dbase and not app: show_info("Interrupted on not-first-time; no need to save partial progress\n")
    while copy_of_runner_events:
        cancelledEvent = copy_of_runner_events[0][0]
        try: runner.cancel(copy_of_runner_events[0][1])
        except: pass
        del copy_of_runner_events[0]
        if hasattr(cancelledEvent,"wordToCancel") and cancelledEvent.wordToCancel: cancelledFiles.append(cancelledEvent.wordToCancel)
    if not app and needCountItems and cancelledFiles: show_info("(%d cancelled items)...\n" % len(cancelledFiles))
    global repeatMode ; repeatMode = "interrupted"
tkNumWordsToShow = 10
def addStatus(*_): pass # trimmed
def makeButton(*_): pass # trimmed
def addButton(*_): pass # trimmed
def addLabel(*_): pass # trimmed
def CXVMenu(e): pass # trimmed
def selectAll(e): pass # trimmed
def selectAllButNumber(e): pass # trimmed
def addTextBox(*_): pass # trimmed
def bindUpDown(*_): pass # trimmed
def addLabelledBox(*_): pass # trimmed
def addRow(*_): pass # trimmed
def addRightRow(*_): pass # trimmed
def make_output_row(*_): pass # trimmed
def updateSettingsFile(fname,newVals):
    replacement_lines = []
    try: oldLines=u8strip(read(fname)).replace(B("\r\n"),B("\n")).split(B("\n"))
    except IOError: oldLines=[]
    for l in oldLines:
        found=0
        for k in list(newVals.keys()):
            if l.startswith(B(k)):
                replacement_lines.append(B(k+"="+repr(newVals[k])))
                del newVals[k]
                found=1
        if not found: replacement_lines.append(l)
    for k,v in list(newVals.items()): replacement_lines.append(B(k+"="+repr(v)))
    if replacement_lines and replacement_lines[-1]: replacement_lines.append(B("")) # ensure blank line at end so there's a \n but we don't add 1 more with each save
    writeB(open(fname,"w"),B("\n").join(replacement_lines))
def asUnicode(x):
    try: return u""+x # original behaviour
    except:
        try: return x.decode("utf-8")
        except: return x.decode("iso-8859-1") # TODO can we get what it actually IS? (on German WinXP, sys.getdefaultencoding==ascii and locale==C but Tkinter still returns Latin1)
def setupScrollbar(*_): pass # trimmed
shortDescriptionName = "short-description"+dottxt
longDescriptionName = "long-description"+dottxt
class ExtraButton(object): pass # trimmed
extra_buttons_waiting_list = []
def make_extra_buttons_waiting_list(): pass # trimmed
def focusButton(*_): pass # trimmed
if 0: pass # trimmed
def startTk(): pass # trimmed
def hanzi_only(unitext): return u"".join(filter(lambda x:0x3000<ord(x)<0xa700 or ord(x)>=0x10000, list(unitext)))
def hanzi_and_punc(unitext): return u"".join(filter(lambda x:0x3000<ord(x)<0xa700 or ord(x)>=0x10000 or x in '.,?;:\'()[]!0123456789-', list(remove_tone_numbers(fix_compatibility(unitext))))) # no " as it could be from SGML markup
def guiVocabList(parsedVocab):
    sl2,fl2 = "_"+secondLanguage,"_"+firstLanguage
    sl3,fl3 = sl2+dottxt, fl2+dottxt
    sl2Len,fl2Len = -len(sl2),-len(fl2)
    ret = []
    for a,b,c in parsedVocab:
        if c.endswith(sl2): c=c[:sl2Len]
        elif c.endswith(sl3): c=readText(c)
        else: continue
        if type(b)==type([]): b=b[cond(len(b)==3,1,-1)]
        if b.endswith(fl2): b=b[:fl2Len]
        elif b.endswith(fl3): b=readText(b)
        else: continue
        ret.append((ensure_unicode(c),ensure_unicode(b)))
    return ret
def readText(l):
    l = B(samplesDirectory)+B(os.sep)+B(l)
    if checkIn(l,variantFiles):
        if B(os.sep) in l: lp=(l+B(os.sep))[:l.rfind(B(os.sep))]+B(os.sep)
        else: lp = B("")
        varList = filter(lambda x:x.endswith(B(dottxt)),variantFiles[l])
        varList.sort()
        l = lp + varList[0]
    return bwspstrip(u8strip(read(l)))
def singular(number,s):
  s=localise(s)
  if firstLanguage=="en" and number==1 and s[-1]=="s": return s[:-1]
  return s
def localise(s):
  if s=="zh-yue" or s=="zhy": k="cant"
  else: k=s
  d = GUI_translations.get(k,{}) ; s2 = 0
  GUIlang = GUI_languages.get(firstLanguage,firstLanguage)
  if scriptVariants.get(GUIlang,0): s2 = d.get(GUIlang+str(scriptVariants[GUIlang]+1),0)
  if not s2: s2 = d.get(GUIlang,s)
  return s2
if 0: pass # trimmed
if 0: pass # trimmed
def synchronizeListbox(*_): pass # trimmed
if 0: pass # trimmed
def openDirectory(*_): pass # trimmed
def generalCheck(text,language,pauseOnError=0):
    if not text: return
    if pauseOnError:
        ret = generalCheck(text,language)
        if ret: waitOnMessage(ret)
        return ret
    if language=="zh":
        allDigits = True ; text=B(text)
        for i in xrange(len(text)):
            t = text[i:i+1]
            if ord(t)>127: return
            if t in B("12345"): return # got tone numbers
            if t not in B("0123456789. "): allDigits = False
        if allDigits: return
        return B("Pinyin needs tones.  Please go back and add tone numbers to ")+text+B(".")+cond(startBrowser(B("http://www.mdbg.net/chinese/dictionary?wdqb=")+bwspstrip(fix_pinyin(text,[])).replace(B("5"),B("")).replace(B(" "),B("+"))),B(" Gradint has pointed your web browser at an online dictionary that might help."),B(""))
def check_for_slacking(): pass # trimmed
def checkAge(*_): pass # trimmed
def s60_addVocab():
  label1,label2 = ensure_unicode(localise("Word in %s") % localise(secondLanguage)),ensure_unicode(localise("Meaning in %s") % localise(firstLanguage))
  while True:
    result = appuifw.multi_query(label1,label2)
    if not result: return
    l2,l1 = result
    while generalCheck(l2.encode('utf-8'),secondLanguage,1):
        l2=appuifw.query(label1,"text",u"")
        if not l2: return
    appuifw.note(u"Added "+l2+"="+l1,"conf")
    appendVocabFileInRightLanguages().write((l2+"="+l1+"\n").encode("utf-8"))
def s60_changeLang():
    global firstLanguage,secondLanguage
    result = appuifw.multi_query(ensure_unicode(localise("Your first language")+" (e.g. "+firstLanguage+")"),ensure_unicode(localise("second")+" (e.g. "+secondLanguage+")"))
    if not result: return
    l1,l2 = result
    firstLanguage,secondLanguage = l1.encode('utf-8').lower(),l2.encode('utf-8').lower()
    updateSettingsFile(settingsFile,{"firstLanguage":firstLanguage,"secondLanguage":secondLanguage})
def s60_runLesson():
    global maxLenOfLesson
    ml = appuifw.query(u"Max number of minutes","number",int(maxLenOfLesson/60))
    if not ml: return
    maxLenOfLesson = int(float(ml)*60)
    lesson_loop()
def s60_viewVocab():
    global justSynthesize
    doLabel("Reading your vocab list, please wait...")
    vList = map(lambda x:x[0]+u"="+x[1], guiVocabList(parseSynthVocab(vocabFile,1)))
    if not vList: return waitOnMessage("Your computer-voiced vocab list is empty.")
    while True:
      appuifw.app.body = None
      sel = appuifw.selection_list(vList,search_field=1)
      if sel==None: return
      l2,l1 = vList[sel].split("=",1)
      action = appuifw.popup_menu([u"Speak (just "+secondLanguage+")",u"Speak ("+secondLanguage+" and "+firstLanguage+")",u"Change "+secondLanguage,u"Change "+firstLanguage,u"Delete item",u"Cancel"], vList[sel])
      if action==0 or action==1:
        doLabel("Speaking...")
        justSynthesize = B(secondLanguage)+B(" ")+l2.encode('utf-8')
        if action==1: justSynthesize += (B('#')+B(firstLanguage)+B(" ")+l1.encode('utf-8'))
        just_synthesize()
        justSynthesize = ""
      elif action==5: pass
      else:
          if action==4 and not getYN(u"Are you sure you want to delete "+vList[sel]+"?"): continue
          oldL1,oldL2 = l1,l2
          if action==2:
              first=1
              while first or (l2 and generalCheck(l2.encode('utf-8'),secondLanguage,1)):
                  first=0 ; l2=appuifw.query(ensure_unicode(secondLanguage),"text",l2)
              if not l2: continue
          elif action==3:
              l1 = appuifw.query(ensure_unicode(firstLanguage),"text",l1)
              if not l1: continue
          doLabel("Processing")
          delOrReplace(oldL2,oldL1,l2,l1,cond(action==4,"delete","replace"))
          if action==4:
              del vList[sel]
              if not vList: return
          else: vList[sel] = l2+"="+l1
def android_addVocab(): pass # trimmed
def android_changeLang(): pass # trimmed
def delOrReplace(L2toDel,L1toDel,newL2,newL1,action="delete"):
    langs = [secondLanguage,firstLanguage]
    v=u8strip(read(vocabFile)).replace(B("\r\n"),B("\n")).replace(B("\r"),B("\n"))
    if 0: pass # trimmed
    else: o=open(vocabFile,"w")
    found = 0
    if last_u8strip_found_BOM: writeB(o,LB('\xef\xbb\xbf')) # re-write it
    v=v.split(B("\n"))
    if v and not v[-1]: v=v[:-1]
    for l in v:
        l2=l.lower()
        if l2.startswith(B("set language ")) or l2.startswith(B("set languages ")):
            langs=map(S,l.split()[2:]) ; writeB(o,l+B("\n")) ; continue
        thisLine=map(bwspstrip,l.split(B("="),len(langs)-1))
        if (langs==[secondLanguage,firstLanguage] and thisLine==[L2toDel.encode('utf-8'),L1toDel.encode('utf-8')]) or (langs==[firstLanguage,secondLanguage] and thisLine==[L1toDel.encode('utf-8'),L2toDel.encode('utf-8')]):
            found = 1
            if action=="replace":
                if langs==[secondLanguage,firstLanguage]: writeB(o,newL2.encode("utf-8")+B("=")+newL1.encode("utf-8")+B("\n"))
                else: writeB(o,newL1.encode("utf-8")+B("=")+newL2.encode("utf-8")+B("\n"))
        else: writeB(o,l+B("\n"))
    o.close()
    if 0: pass # trimmed
    return found
def maybeCanSynth(lang): return checkIn(lang,synth_partials_voices) or get_synth_if_possible(lang,0) or synthCache
def android_main_menu(): pass # trimmed
def s60_main_menu():
  while True:
    appuifw.app.body = None
    menu=[]
    if maybeCanSynth(secondLanguage):
        menu.append((u"Just speak a word",primitive_synthloop))
        doVocab = maybeCanSynth(firstLanguage)
        if doVocab: menu.append((u"Add word to my vocab",s60_addVocab))
        menu.append((u"Make lesson from vocab",s60_runLesson))
        if doVocab: menu.append((u"View/change vocab",s60_viewVocab))
    else: menu.append((u"Make lesson",s60_runLesson))
    menu += [(u"Record word(s) with mic",s60_recordWord),(u"Change languages",s60_changeLang)]
    if len(menu)<5: menu.append((u"Quit",None))
    choice = appuifw.popup_menu(map (lambda x:x[0], menu),u"Choose an action:") # (selection_list can be better than popup_menu(l,u"Choose an action:") if over 5 items, but may need further trimming the width of each item) (the Quit item can go however - can cancel the menu instead.  Or keep it & don't mind it being off-screen c.f. in-vocab-list popup.)
    try: function = menu[choice][1]
    except: break
    if function: function()
    else: break
def downloadLAME(): pass # trimmed
def gui_event_loop(): pass # trimmed
def vocabLinesWithLangs(): pass # trimmed
def appendVocabFileInRightLanguages():
    langs = [secondLanguage,firstLanguage]
    try: v=u8strip(read(vocabFile)).replace(B("\r"),B("\n"))
    except IOError: v=B("")
    for l in v.split(B("\n")):
        l2=l.lower()
        if l2.startswith(B("set language ")) or l2.startswith(B("set languages ")):
            langs=l.split()[2:]
            for i in range(len(langs)): langs[i]=S(langs[i])
    try: o=open(vocabFile,"ab") # (ensure binary on Python 3)
    except IOError:
        show_warning("Cannot write to "+vocabFile+" (current directory is "+os.getcwd()+")")
        return
    if not v.endswith(B("\n")): o.write(B("\n"))
    if not langs==[secondLanguage,firstLanguage]: o.write(B("SET LANGUAGES "+secondLanguage+" "+firstLanguage+"\n"))
    return o
def transliterates_differently(text,lang):
    global last_partials_transliteration ; last_partials_transliteration=None
    global partials_are_sporadic ; o=partials_are_sporadic ; partials_are_sporadic = None
    if synthcache_lookup(B("!synth:")+B(text)+B("_")+B(lang)):
        partials_are_sporadic = o
        if last_partials_transliteration and not last_partials_transliteration==text: return last_partials_transliteration
        else: return
    partials_are_sporadic = o
    synth=get_synth_if_possible(lang,0)
    if not synth or not synth.can_transliterate(lang): return
    translit=synth.transliterate(lang,text,forPartials=0)
    if translit and not translit==text: return translit
def gui_outputTo_start(): pass # trimmed
def gui_outputTo_end(*_): pass # trimmed
def main():
    global useTK,justSynthesize,waitBeforeStart,traceback,appTitle,app,warnings_toprint
    if 0: pass # trimmed
    else:
        app = None
        if not appuifw and not android:
            for w in warnings_toprint: show_warning(w)
        warnings_toprint = [] ; rest_of_main()
def rest_of_main():
    global useTK,justSynthesize,waitBeforeStart,traceback,appTitle,saveProgress,RM_running
    exitStatus = 0 ; RM_running = 1
    try:
        try: ceLowMemory
        except NameError: ceLowMemory=0
        if ceLowMemory and getYN("Low memory! Python may crash. Turn off progress saving for safety?"): saveProgress=0
        if B(justSynthesize)==B("-"): primitive_synthloop()
        elif justSynthesize and B(justSynthesize)[-1:]==B('*'):
            justSynthesize=justSynthesize[:-1]
            waitBeforeStart = 0
            just_synthesize() ; lesson_loop()
        elif justSynthesize: just_synthesize()
        elif app and waitBeforeStart: gui_event_loop()
        elif appuifw: s60_main_menu()
        else: lesson_loop()
    except SystemExit:
        e = sys.exc_info()[1]
        exitStatus = e.code
    except KeyboardInterrupt: pass
    except PromptException:
        prEx = sys.exc_info()[1]
        waitOnMessage("\nProblem finding prompts:\n"+prEx.message+"\n")
        exitStatus = 1
    except MessageException:
        mEx = sys.exc_info()[1]
        waitOnMessage(mEx.message+"\n") ; exitStatus = 1
    except:
        w="\nSomething has gone wrong with my program.\nThis is not your fault.\nPlease let me know what it says.\nThanks.  Silas\n"+exc_info()
        try: import traceback
        except:
            w += "Cannot import traceback\n"
            traceback = None
        if traceback and useTK: traceback.print_exc()
        try: tracebackFile=open("last-gradint-error"+extsep+"txt","w")
        except: tracebackFile=None
        if tracebackFile:
            try:
                tracebackFile.write(time.asctime()+":\n"+w+"\n")
                if traceback: traceback.print_exc(None,tracebackFile)
                tracebackFile.close()
                if traceback: w += "Details have been written to "+os.getcwd()+os.sep+"last-gradint-error"+extsep+"txt" # do this only if there's a traceback, otherwise little point
            except: pass
        try:
            global soundCollector
            if 0: pass # trimmed
            if not soundCollector and get_synth_if_possible("en",0): synth_event("en","Error in graddint program.").play() # if possible, give some audio indication of the error (double D to try to force correct pronunciation if not eSpeak, e.g. S60)
        except: pass
        waitOnMessage(w.strip())
        if not useTK:
            if tracebackFile: writeB(sys.stderr,read("last-gradint-error"+extsep+"txt"))
            elif traceback: traceback.print_exc()
        exitStatus = 1
        if appuifw: raw_input()
    global viable_synths,getsynth_cache,theMp3FileCache,globalEspeakSynth
    del viable_synths,getsynth_cache,theMp3FileCache,globalEspeakSynth
    if 0: pass # trimmed
    elif not app==None: pass
    elif appuifw: appuifw.app.set_exit()
    elif not android:
        try:
            doLabelLastLen ; show_info("\n") # if got any \r'd string there - don't want to confuse the next prompt
        except NameError: pass
    RM_running = 0
    if exitStatus: sys.exit(exitStatus)
if __name__=="__main__": main() # Note: calling main() is the ONLY control logic that can happen under the 'if __name__=="__main__"' block; everything else should be in main() itself.  This is because gradint-wrapper.exe under Windows calls main() from the exe and does not call this block
